/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.util.manager;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.service.AccountService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.common.CommonContext;
import io.nuls.common.ConfigBean;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class ChainManager {
    @Autowired
    NulsCoresConfig accountConfig;
    private Map<Integer, Chain> chainMap = new ConcurrentHashMap<Integer, Chain>();

    public void initChain() throws Exception {
        Map<Integer, ConfigBean> configMap = this.configChain();
        if (configMap == null || configMap.size() == 0) {
            return;
        }
        for (Map.Entry<Integer, ConfigBean> entry : configMap.entrySet()) {
            Chain chain = new Chain();
            int chainId = entry.getKey();
            chain.setConfig(entry.getValue());
            this.initLogger(chain);
            this.initTable(chainId);
            this.chainMap.put(chainId, chain);
        }
        AccountService accountService = (AccountService)SpringLiteContext.getBean(AccountService.class);
        accountService.getAccountList();
    }

    public void runChain() {
    }

    public void stopChain(int chainId) {
    }

    private Map<Integer, ConfigBean> configChain() {
        try {
            Map<Integer, ConfigBean> configMap = CommonContext.CONFIG_BEAN_MAP;
            NulsCoresConfig configBean = this.accountConfig;
            configMap.put(((ConfigBean)configBean).getChainId(), configBean);
            return configMap;
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
            return null;
        }
    }

    private void initTable(int chainId) {
        try {
            if (!RocksDBService.existTable((String)("account_alias_key_alias" + chainId))) {
                RocksDBService.createTable((String)("account_alias_key_alias" + chainId));
            }
            if (!RocksDBService.existTable((String)("account_alias_key_address" + chainId))) {
                RocksDBService.createTable((String)("account_alias_key_address" + chainId));
            }
        }
        catch (Exception e) {
            if (!"DB table exists".equals(e.getMessage())) {
                LoggerUtil.LOG.error(e.getMessage());
                throw new NulsRuntimeException(AccountErrorCode.DB_TABLE_CREATE_ERROR);
            }
            LoggerUtil.LOG.info(e.getMessage());
        }
    }

    private void initLogger(Chain chain) {
        LoggerUtil.init(chain);
    }

    public Map<Integer, Chain> getChainMap() {
        return this.chainMap;
    }

    public void setChainMap(Map<Integer, Chain> chainMap) {
        this.chainMap = chainMap;
    }

    public Chain getChain(int key) {
        return this.chainMap.get(key);
    }
}

