/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.manager;

import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.constant.ChainTypeEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.Chain;
import io.nuls.block.model.CheckResult;
import io.nuls.block.rpc.call.ConsensusCall;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.service.BlockService;
import io.nuls.block.storage.ChainStorageService;
import io.nuls.block.thread.BlockSynchronizer;
import io.nuls.block.utils.BlockUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.logback.NulsLogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

@Component
public class BlockChainManager {
    @Autowired
    private static BlockService blockService;
    @Autowired
    private static ChainStorageService chainStorageService;
    private static Map<Integer, Chain> masterChains;
    private static Map<Integer, SortedSet<Chain>> forkChains;
    private static Map<Integer, SortedSet<Chain>> orphanChains;

    public static CheckResult switchChain(int chainId, Chain masterChain, Chain forkChain) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            logger.info("*switch chain start");
            logger.info("*masterChain-" + masterChain);
            logger.info("*forkChain-" + forkChain);
            ArrayDeque<Chain> switchChainPath = new ArrayDeque<Chain>();
            while (forkChain.getParent() != null) {
                switchChainPath.push(forkChain);
                forkChain = forkChain.getParent();
            }
            Chain topForkChain = (Chain)switchChainPath.peek();
            long forkHeight = topForkChain.getStartHeight();
            long masterChainEndHeight = masterChain.getEndHeight();
            if (masterChainEndHeight < forkHeight) {
                logger.error("*masterChainEndHeight < forkHeight, data error");
                NetworkCall.resetNetwork(chainId);
                ConsensusCall.notice(chainId, 0);
                TransactionCall.notice(chainId, 0);
                BlockSynchronizer.syn(chainId);
                return new CheckResult(false, true);
            }
            logger.info("*calculate fork point complete, forkHeight=" + forkHeight);
            ArrayDeque<NulsHash> hashList = new ArrayDeque<NulsHash>();
            Stack<Block> blockStack = new Stack<Block>();
            long rollbackHeight = masterChainEndHeight;
            logger.info("*rollback master chain begin, rollbackHeight=" + rollbackHeight);
            do {
                Block block = blockService.getBlock(chainId, rollbackHeight--);
                NulsHash hash = block.getHeader().getHash();
                if (!blockService.rollbackBlock(chainId, BlockUtil.toBlockHeaderPo(block), false)) {
                    logger.info("*rollback master chain doing, fail hash=" + hash);
                    BlockChainManager.saveBlockToMasterChain(chainId, blockStack);
                    return new CheckResult(false, false);
                }
                blockStack.push(block);
                hashList.offerFirst(hash);
                logger.info("*rollback master chain doing, success hash=" + hash);
            } while (rollbackHeight >= forkHeight);
            logger.info("*rollback master chain end");
            Chain masterForkChain = new Chain();
            masterForkChain.setParent(masterChain);
            masterForkChain.setStartHeight(forkHeight);
            masterForkChain.setEndHeight(masterChainEndHeight);
            masterForkChain.setChainId(chainId);
            masterForkChain.setPreviousHash(topForkChain.getPreviousHash());
            masterForkChain.setHashList(hashList);
            masterForkChain.setType(ChainTypeEnum.FORK);
            masterForkChain.setStartHashCode(hashList.getFirst().hashCode());
            logger.info("*generate new masterForkChain chain-" + masterForkChain);
            SortedSet<Chain> higherChains = masterChain.getSons().tailSet(topForkChain);
            if (higherChains.size() > 1) {
                logger.info("*higher than topForkChain-" + higherChains);
                higherChains.remove(topForkChain);
                masterForkChain.setSons(higherChains);
                higherChains.forEach(e -> e.setParent(masterForkChain));
            }
            BlockChainManager.addForkChain(chainId, masterForkChain);
            if (!chainStorageService.save(chainId, blockStack)) {
                logger.info("*error occur when save masterForkChain");
                BlockChainManager.append(masterChain, masterForkChain);
                return new CheckResult(false, false);
            }
            logger.info("*masterChain rollback complete");
            ArrayList<Chain> delete = new ArrayList<Chain>();
            while (!switchChainPath.isEmpty()) {
                Chain chain = (Chain)switchChainPath.pop();
                delete.add(chain);
                Chain subChain = switchChainPath.isEmpty() ? null : (Chain)switchChainPath.peek();
                boolean b = BlockChainManager.switchChain0(chainId, masterChain, chain, subChain);
                if (b) continue;
                while (masterChain.getEndHeight() >= forkHeight) {
                    blockService.rollbackBlock(chainId, masterChain.getEndHeight(), false);
                }
                logger.info("*switchChain0 fail masterChain-" + masterChain + ",chain-" + chain + ",subChain-" + subChain + ",masterForkChain-" + masterForkChain);
                BlockChainManager.deleteForkChain(chainId, topForkChain, true);
                BlockChainManager.append(masterChain, masterForkChain);
                return new CheckResult(false, false);
            }
            delete.forEach(e -> BlockChainManager.deleteForkChain(chainId, e, false));
            logger.info("*switch chain complete");
        }
        catch (Exception e2) {
            logger.error("block chain switch fail, auto rollback fail, process exit.");
            System.exit(1);
        }
        return new CheckResult(true, false);
    }

    private static void saveBlockToMasterChain(int chainId, Stack<Block> blockStack) {
        while (!blockStack.empty()) {
            if (blockService.saveBlock(chainId, blockStack.pop(), false)) continue;
            ContextManager.getContext(chainId).getLogger().error("block chain switch fail, auto rollback fail, process exit.");
            System.exit(1);
        }
    }

    private static boolean switchChain0(int chainId, Chain masterChain, Chain forkChain, Chain subChain) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        logger.info("*switchChain0 masterChain=" + masterChain + ",forkChain=" + forkChain + ",subChain=" + subChain);
        int target = subChain != null ? (int)(subChain.getStartHeight() - forkChain.getStartHeight()) : (int)(forkChain.getEndHeight() - forkChain.getStartHeight()) + 1;
        logger.info("*switchChain0 target=" + target);
        Object hashList = ((ArrayDeque)forkChain.getHashList()).clone();
        for (int count = 0; target > count; ++count) {
            NulsHash hash = (NulsHash)hashList.pop();
            Block block = chainStorageService.query(chainId, hash);
            boolean saveBlock = blockService.saveBlock(chainId, block, false);
            if (saveBlock) {
                continue;
            }
            logger.info("*switchChain0 saveBlock fail, hash=" + hash);
            return false;
        }
        logger.info("*switchChain0 add block to master chain success");
        if (!hashList.isEmpty()) {
            SortedSet<Chain> higherSubChains;
            Chain newForkChain = new Chain();
            newForkChain.setChainId(chainId);
            newForkChain.setStartHeight((long)target + forkChain.getStartHeight());
            newForkChain.setParent(masterChain);
            newForkChain.setEndHeight(forkChain.getEndHeight());
            newForkChain.setPreviousHash(subChain.getPreviousHash());
            newForkChain.setHashList((Deque<NulsHash>)hashList);
            newForkChain.setStartHashCode(((NulsHash)hashList.getFirst()).hashCode());
            logger.info("*switchChain0 newForkChain-" + newForkChain);
            SortedSet<Chain> lowerSubChains = forkChain.getSons().headSet(subChain);
            if (!lowerSubChains.isEmpty()) {
                lowerSubChains.forEach(e -> e.setParent(masterChain));
                masterChain.getSons().addAll(lowerSubChains);
                lowerSubChains.forEach(e -> logger.info("*switchChain0 lowerSubChains-" + e));
            }
            if ((higherSubChains = forkChain.getSons().tailSet(subChain)).size() > 1) {
                higherSubChains.remove(subChain);
                higherSubChains.forEach(e -> e.setParent(newForkChain));
                newForkChain.setSons(higherSubChains);
                higherSubChains.forEach(e -> logger.info("*switchChain0 higherSubChains-" + e));
            }
            BlockChainManager.addForkChain(chainId, newForkChain);
        }
        return true;
    }

    public static void setMasterChain(int chainId, Chain chain) {
        masterChains.put(chainId, chain);
    }

    public static Chain getMasterChain(int chainId) {
        return masterChains.get(chainId);
    }

    public static void addForkChain(int chainId, Chain chain) {
        boolean add = forkChains.get(chainId).add(chain);
        if (!add) {
            ContextManager.getContext(chainId).getLogger().warn("add fail, forkChain-" + chain);
        }
    }

    public static void deleteForkChain(int chainId, Chain forkChain, boolean recursive) {
        forkChains.get(chainId).remove(forkChain);
        chainStorageService.remove(chainId, forkChain.getHashList());
        ContextManager.getContext(chainId).getLogger().info("delete Fork Chain-" + forkChain);
        if (recursive && !forkChain.getSons().isEmpty()) {
            forkChain.getSons().forEach(e -> BlockChainManager.deleteForkChain(chainId, e, true));
        }
    }

    public static SortedSet<Chain> getForkChains(int chainId) {
        SortedSet<Chain> chains = forkChains.get(chainId);
        return chains == null ? Collections.emptySortedSet() : chains;
    }

    public static void setForkChains(int chainId, SortedSet<Chain> chains) {
        forkChains.put(chainId, chains);
    }

    public static void addOrphanChain(int chainId, Chain chain) {
        boolean add = orphanChains.get(chainId).add(chain);
        if (!add) {
            ContextManager.getContext(chainId).getLogger().warn("add fail, orphanChain-" + chain);
        }
    }

    public static SortedSet<Chain> getOrphanChains(int chainId) {
        SortedSet<Chain> chains = orphanChains.get(chainId);
        return chains == null ? Collections.emptySortedSet() : chains;
    }

    public static void setOrphanChains(int chainId, SortedSet<Chain> chains) {
        orphanChains.put(chainId, chains);
    }

    public static boolean append(Chain mainChain, Chain subChain) {
        int chainId = mainChain.getChainId();
        if (mainChain.isMaster()) {
            ConsensusCall.notice(chainId, 0);
            TransactionCall.notice(chainId, 0);
            List<Block> blockList = chainStorageService.query(subChain.getChainId(), subChain.getHashList());
            ArrayList<Block> savedBlockList = new ArrayList<Block>();
            for (Block block : blockList) {
                if (!blockService.saveBlock(chainId, block, false)) {
                    for (int i = savedBlockList.size() - 1; i >= 0; --i) {
                        if (blockService.rollbackBlock(chainId, ((Block)savedBlockList.get(i)).getHeader().getHeight(), false)) continue;
                        ContextManager.getContext(chainId).getLogger().error("block chain data error, can't restore, system exit");
                        System.exit(1);
                    }
                    throw new NulsRuntimeException(BlockErrorCode.CHAIN_SWITCH_ERROR);
                }
                savedBlockList.add(block);
            }
            ConsensusCall.notice(chainId, 1);
            TransactionCall.notice(chainId, 1);
        }
        if (!mainChain.isMaster()) {
            mainChain.getHashList().addAll(subChain.getHashList());
        }
        mainChain.setEndHeight(subChain.getEndHeight());
        mainChain.getSons().addAll(subChain.getSons());
        subChain.getSons().forEach(e -> e.setParent(mainChain));
        subChain.setParent(mainChain);
        return true;
    }

    public static boolean fork(Chain mainChain, Chain forkChain) {
        forkChain.setParent(mainChain);
        return mainChain.getSons().add(forkChain);
    }

    public static void deleteOrphanChain(int chainId, Chain orphanChain) {
        orphanChains.get(chainId).remove(orphanChain);
        chainStorageService.remove(chainId, orphanChain.getHashList());
        ContextManager.getContext(chainId).getLogger().info("delete Orphan Chain-" + orphanChain);
        if (!orphanChain.getSons().isEmpty()) {
            orphanChain.getSons().forEach(e -> BlockChainManager.deleteOrphanChain(chainId, e));
        }
    }

    public static void init(int chainId) {
        forkChains.put(chainId, new TreeSet<Chain>(Chain.COMPARATOR));
        orphanChains.put(chainId, new TreeSet<Chain>(Chain.COMPARATOR));
    }

    static {
        masterChains = new HashMap<Integer, Chain>();
        forkChains = new HashMap<Integer, SortedSet<Chain>>();
        orphanChains = new HashMap<Integer, SortedSet<Chain>>();
    }
}

