/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseBusinessMessage;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class HeightRangeMessage
extends BaseBusinessMessage {
    private long startHeight;
    private long endHeight;

    public HeightRangeMessage() {
    }

    public HeightRangeMessage(long startHeight, long endHeight) {
        this.startHeight = startHeight;
        this.endHeight = endHeight;
    }

    public long getStartHeight() {
        return this.startHeight;
    }

    public void setStartHeight(long startHeight) {
        this.startHeight = startHeight;
    }

    public long getEndHeight() {
        return this.endHeight;
    }

    public void setEndHeight(long endHeight) {
        this.endHeight = endHeight;
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfInt64();
        return size += SerializeUtils.sizeOfInt64();
    }

    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeInt64(this.startHeight);
        stream.writeInt64(this.endHeight);
    }

    public void parse(NulsByteBuffer byteBuffer) {
        try {
            this.startHeight = byteBuffer.readInt64();
            this.endHeight = byteBuffer.readInt64();
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
        }
    }

    public String toString() {
        return "HeightRangeMessage{startHeight=" + this.startHeight + ", endHeight=" + this.endHeight + "}";
    }
}

