/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseBusinessMessage;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.NulsData;
import io.nuls.core.basic.VarInt;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TxGroupMessage
extends BaseBusinessMessage {
    private NulsHash blockHash;
    private List<Transaction> transactions;

    public TxGroupMessage() {
    }

    public TxGroupMessage(NulsHash blockHash, List<Transaction> transactions) {
        this.blockHash = blockHash;
        this.transactions = transactions;
    }

    public NulsHash getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(NulsHash blockHash) {
        this.blockHash = blockHash;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public int size() {
        int size = 0;
        size += 32;
        size += VarInt.sizeOf((long)this.transactions.size());
        return size += this.getTxListLength();
    }

    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.blockHash.getBytes());
        stream.writeVarInt(this.transactions.size());
        for (Transaction data : this.transactions) {
            stream.writeNulsData((BaseNulsData)data);
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.blockHash = byteBuffer.readHash();
        long txCount = byteBuffer.readVarInt();
        this.transactions = new ArrayList<Transaction>();
        int i = 0;
        while ((long)i < txCount) {
            try {
                this.transactions.add(byteBuffer.readTransaction());
            }
            catch (Exception e) {
                throw new NulsException((Throwable)e);
            }
            ++i;
        }
    }

    private int getTxListLength() {
        int size = 0;
        for (Transaction tx : this.transactions) {
            size += SerializeUtils.sizeOfNulsData((NulsData)tx);
        }
        return size;
    }
}

