/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Block;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.BlockMessage;
import io.nuls.block.model.ChainContext;
import io.nuls.block.utils.SingleBlockCacher;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;

@Component(value="BlockHandlerV1")
public class BlockHandler
implements MessageProcessor {
    public String getCmd() {
        return "block";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        BlockMessage message = (BlockMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, BlockMessage.class));
        if (message == null) {
            return;
        }
        Block block = message.getBlock();
        if (message.isSyn()) {
            boolean b;
            long height = block.getHeader().getHeight();
            boolean bl = b = height > context.getLatestHeight() && context.isNeedSyn();
            if (b && context.getBlockMap().put(height, block) == null) {
                context.getCachedBlockSize().addAndGet(block.size());
            } else {
                logger.debug("ignore BlockMessage from node-{}, blockHeight-{}, isNeedSyn-{}, LatestHeight-{}", new Object[]{nodeId, height, context.isNeedSyn(), context.getLatestHeight()});
            }
        } else {
            if (block != null) {
                block.setNodeId(nodeId);
            }
            SingleBlockCacher.receiveBlock(chainId, message);
        }
    }
}

