/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.model;

import com.google.common.base.Objects;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.ChainTypeEnum;
import java.util.Comparator;
import java.util.Deque;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public class Chain {
    public static final Comparator<Chain> COMPARATOR = Comparator.comparingLong(Chain::getStartHeight).thenComparingInt(Chain::getStartHashCode).thenComparingLong(Chain::getEndHeight).thenComparingInt(Chain::getEndHashCode);
    private Chain parent;
    private SortedSet<Chain> sons = new TreeSet<Chain>(COMPARATOR);
    private int chainId;
    private NulsHash previousHash;
    private long startHeight;
    private int startHashCode;
    private long endHeight;
    private Deque<NulsHash> hashList;
    private ChainTypeEnum type;
    private AtomicInteger age = new AtomicInteger(0);

    public NulsHash getStartHash() {
        return this.hashList.getFirst();
    }

    public NulsHash getEndHash() {
        return this.hashList.getLast();
    }

    public int getEndHashCode() {
        return this.hashList.getLast().hashCode();
    }

    public boolean isMaster() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals((Object)ChainTypeEnum.MASTER);
    }

    public Chain getParent() {
        return this.parent;
    }

    public void setParent(Chain parent) {
        this.parent = parent;
    }

    public SortedSet<Chain> getSons() {
        return this.sons;
    }

    public void setSons(SortedSet<Chain> sons) {
        this.sons = sons;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public NulsHash getPreviousHash() {
        return this.previousHash;
    }

    public void setPreviousHash(NulsHash previousHash) {
        this.previousHash = previousHash;
    }

    public long getStartHeight() {
        return this.startHeight;
    }

    public void setStartHeight(long startHeight) {
        this.startHeight = startHeight;
    }

    public int getStartHashCode() {
        return this.startHashCode;
    }

    public void setStartHashCode(int startHashCode) {
        this.startHashCode = startHashCode;
    }

    public long getEndHeight() {
        return this.endHeight;
    }

    public void setEndHeight(long endHeight) {
        this.endHeight = endHeight;
    }

    public Deque<NulsHash> getHashList() {
        return this.hashList;
    }

    public void setHashList(Deque<NulsHash> hashList) {
        this.hashList = hashList;
    }

    public ChainTypeEnum getType() {
        return this.type;
    }

    public void setType(ChainTypeEnum type) {
        this.type = type;
    }

    public AtomicInteger getAge() {
        return this.age;
    }

    public void setAge(AtomicInteger age) {
        this.age = age;
    }

    public void addFirst(Block block) {
        BlockHeader blockHeader = block.getHeader();
        this.setPreviousHash(blockHeader.getPreHash());
        this.setStartHeight(blockHeader.getHeight());
        this.getHashList().addFirst(blockHeader.getHash());
        this.setStartHashCode(blockHeader.getHash().hashCode());
    }

    public void addLast(Block block) {
        this.setEndHeight(block.getHeader().getHeight());
        this.getHashList().addLast(block.getHeader().getHash());
    }

    public String toString() {
        return new StringJoiner(", ", Chain.class.getSimpleName() + "[", "]").add("parentStartHashCode=" + (this.getParent() == null ? null : Integer.valueOf(this.getParent().getStartHashCode()))).add("startHashCode=" + this.startHashCode).add("startHeight=" + this.startHeight).add("endHeight=" + this.endHeight).add("type=" + this.type).add("age=" + this.age).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chain chain = (Chain)o;
        return this.chainId == chain.chainId && this.startHeight == chain.startHeight && this.startHashCode == chain.startHashCode && this.endHeight == chain.endHeight && Objects.equal((Object)this.previousHash, (Object)chain.previousHash) && Objects.equal(this.hashList, chain.hashList) && this.type == chain.type && Objects.equal((Object)this.age, (Object)chain.age);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.chainId, this.previousHash, this.startHeight, this.startHashCode, this.endHeight, this.hashList, this.type, this.age});
    }
}

