/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.model;

import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.StatusEnum;
import io.nuls.block.manager.BlockChainManager;
import io.nuls.block.model.BlockDownloaderParams;
import io.nuls.block.model.Chain;
import io.nuls.block.thread.monitor.TxGroupRequestor;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.block.utils.SingleBlockCacher;
import io.nuls.block.utils.SmallBlockCacher;
import io.nuls.common.ConfigBean;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;

public class ChainContext {
    private StatusEnum status;
    private boolean needSyn;
    private int chainId;
    private List<Integer> systemTransactionType;
    private long networkHeight;
    private Block latestBlock;
    private Block genesisBlock;
    private ConfigBean parameters;
    private StampedLock lock;
    private NulsLogger logger;
    private Map<String, AtomicInteger> duplicateBlockMap;
    private List<String> packingAddressList;
    private Map<NulsHash, Long> cachedHashHeightMap;
    private AtomicInteger cachedBlockSize;
    private BlockDownloaderParams downloaderParams;
    private Map<Long, Block> blockMap = new ConcurrentHashMap<Long, Block>(100);
    private Map<NulsHash, List<String>> orphanBlockRelatedNodes;

    public Map<NulsHash, List<String>> getOrphanBlockRelatedNodes() {
        return this.orphanBlockRelatedNodes;
    }

    public void setOrphanBlockRelatedNodes(Map<NulsHash, List<String>> orphanBlockRelatedNodes) {
        this.orphanBlockRelatedNodes = orphanBlockRelatedNodes;
    }

    public Map<Long, Block> getBlockMap() {
        return this.blockMap;
    }

    public void setBlockMap(Map<Long, Block> blockMap) {
        this.blockMap = blockMap;
    }

    public BlockDownloaderParams getDownloaderParams() {
        return this.downloaderParams;
    }

    public void setDownloaderParams(BlockDownloaderParams downloaderParams) {
        this.downloaderParams = downloaderParams;
    }

    public AtomicInteger getCachedBlockSize() {
        return this.cachedBlockSize;
    }

    public void setCachedBlockSize(AtomicInteger cachedBlockSize) {
        this.cachedBlockSize = cachedBlockSize;
    }

    public Map<NulsHash, Long> getCachedHashHeightMap() {
        return this.cachedHashHeightMap;
    }

    public void setCachedHashHeightMap(Map<NulsHash, Long> cachedHashHeightMap) {
        this.cachedHashHeightMap = cachedHashHeightMap;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public boolean isNeedSyn() {
        return this.needSyn;
    }

    public void setNeedSyn(boolean needSyn) {
        this.needSyn = needSyn;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public List<Integer> getSystemTransactionType() {
        return this.systemTransactionType;
    }

    public void setSystemTransactionType(List<Integer> systemTransactionType) {
        this.systemTransactionType = systemTransactionType;
    }

    public Block getLatestBlock() {
        return this.latestBlock;
    }

    public void setLatestBlock(Block latestBlock) {
        this.latestBlock = latestBlock;
    }

    public Block getGenesisBlock() {
        return this.genesisBlock;
    }

    public void setGenesisBlock(Block genesisBlock) {
        this.genesisBlock = genesisBlock;
    }

    public ConfigBean getParameters() {
        return this.parameters;
    }

    public void setParameters(ConfigBean parameters) {
        this.parameters = parameters;
    }

    public StampedLock getLock() {
        return this.lock;
    }

    public void setLock(StampedLock lock) {
        this.lock = lock;
    }

    public NulsLogger getLogger() {
        return this.logger;
    }

    public void setLogger(NulsLogger logger) {
        this.logger = logger;
    }

    public Map<String, AtomicInteger> getDuplicateBlockMap() {
        return this.duplicateBlockMap;
    }

    public void setDuplicateBlockMap(Map<String, AtomicInteger> duplicateBlockMap) {
        this.duplicateBlockMap = duplicateBlockMap;
    }

    public long getNetworkHeight() {
        return this.networkHeight;
    }

    public void setNetworkHeight(long networkHeight) {
        this.networkHeight = networkHeight;
    }

    public List<String> getPackingAddressList() {
        return this.packingAddressList;
    }

    public void setPackingAddressList(List<String> packingAddressList) {
        this.packingAddressList = packingAddressList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(StatusEnum status) {
        if (status.equals((Object)this.getStatus())) {
            return;
        }
        ChainContext chainContext = this;
        synchronized (chainContext) {
            this.logger.debug("status changed:" + this.status + "->" + status);
            this.status = status;
        }
    }

    public long getLatestHeight() {
        if (null == this.latestBlock || null == this.latestBlock.getHeader()) {
            return -1L;
        }
        return this.latestBlock.getHeader().getHeight();
    }

    public void init() {
        LoggerUtil.init(this.chainId);
        this.cachedBlockSize = new AtomicInteger(0);
        this.setStatus(StatusEnum.INITIALIZING);
        this.cachedHashHeightMap = CollectionUtils.getSynSizedMap((int)this.parameters.getSmallBlockCache());
        this.orphanBlockRelatedNodes = CollectionUtils.getSynSizedMap((int)this.parameters.getHeightRange());
        this.packingAddressList = CollectionUtils.getSynList();
        this.duplicateBlockMap = new HashMap<String, AtomicInteger>();
        this.systemTransactionType = new ArrayList<Integer>();
        this.needSyn = true;
        this.lock = new StampedLock();
        SmallBlockCacher.init(this.chainId);
        SingleBlockCacher.init(this.chainId);
        BlockChainManager.init(this.chainId);
        TxGroupRequestor.init(this.chainId);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void printChains() {
        SortedSet<Chain> orphanChains;
        Chain masterChain = BlockChainManager.getMasterChain(this.chainId);
        this.logger.info("-------------------------------------master chain-------------------------------------");
        this.logger.info("-" + masterChain);
        SortedSet<Chain> forkChains = BlockChainManager.getForkChains(this.chainId);
        if (!forkChains.isEmpty()) {
            this.logger.info("-------------------------------------fork chains-------------------------------------");
            for (Chain forkChain : forkChains) {
                this.logger.info("-" + forkChain);
            }
        }
        if (!(orphanChains = BlockChainManager.getOrphanChains(this.chainId)).isEmpty()) {
            this.logger.info("-------------------------------------orphan chains-------------------------------------");
            for (Chain orphanChain : orphanChains) {
                this.logger.info("-" + orphanChain);
            }
        }
    }
}

