/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.rpc.call;

import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.ModuleHelper;
import io.nuls.block.manager.ContextManager;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContractCall {
    public static List<NulsHash> contractOfflineTxHashList(int chainId, String blockHash) throws NulsException {
        if (!ModuleHelper.isSupportSmartContract()) {
            return List.of();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("blockHash", blockHash);
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            String cmd = "sc_contract_offline_tx_hash_list";
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.SC.abbr, (String)cmd, params);
            if (!response.isSuccess()) {
                String errorCode = response.getResponseErrorCode();
                logger.warn("Call interface [{}] error, ErrorCode is {}, ResponseComment:{}", new Object[]{cmd, errorCode, response.getResponseComment()});
                return List.of();
            }
            Map data = (Map)response.getResponseData();
            Map result = (Map)data.get(cmd);
            try {
                logger.info("moduleCode:{}, -cmd:{}, blockhash: {}, contractProcess -rs: {}", new Object[]{ModuleE.SC.abbr, "sc_contract_offline_tx_hash_list", blockHash, JSONUtils.obj2json((Object)result)});
            }
            catch (Exception e) {
                logger.warn("failed to trace sc_contract_offline_tx_hash_list log, error is {}", new Object[]{e.getMessage()});
            }
            Object obj = result.get("list");
            if (null == obj) {
                return List.of();
            }
            ArrayList<NulsHash> hashList = new ArrayList<NulsHash>();
            for (String hashStr : (List)obj) {
                hashList.add(NulsHash.fromHex((String)hashStr));
            }
            return hashList;
        }
        catch (Exception e) {
            logger.error(e);
            throw new NulsException((Throwable)e);
        }
    }
}

