/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread.monitor;

import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.SmallBlock;
import io.nuls.base.data.Transaction;
import io.nuls.block.constant.BlockForwardEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.HashListMessage;
import io.nuls.block.model.CachedSmallBlock;
import io.nuls.block.model.ChainContext;
import io.nuls.block.model.TxGroupTask;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.service.BlockService;
import io.nuls.block.thread.monitor.BaseMonitor;
import io.nuls.block.utils.BlockUtil;
import io.nuls.block.utils.SmallBlockCacher;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.CollectionUtils;
import io.nuls.core.model.DateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.stream.Collectors;

public class TxGroupRequestor
extends BaseMonitor {
    private BlockService blockService = (BlockService)SpringLiteContext.getBean(BlockService.class);
    private static Map<Integer, Map<String, DelayQueue<TxGroupTask>>> map = new HashMap<Integer, Map<String, DelayQueue<TxGroupTask>>>();
    private static final TxGroupRequestor INSTANCE = new TxGroupRequestor();

    private TxGroupRequestor() {
    }

    public static TxGroupRequestor getInstance() {
        return INSTANCE;
    }

    public static void init(int chainId) {
        byte smallBlockCache = ContextManager.getContext(chainId).getParameters().getSmallBlockCache();
        Map cMap = CollectionUtils.getSynSizedMap((int)smallBlockCache);
        map.put(chainId, cMap);
    }

    public static void addTask(int chainId, String hash, TxGroupTask task) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        DelayQueue<TxGroupTask> txGroupTasks = map.get(chainId).get(hash);
        if (txGroupTasks == null) {
            txGroupTasks = new DelayQueue();
            map.get(chainId).put(hash, txGroupTasks);
        }
        boolean add = txGroupTasks.add(task);
    }

    public static void removeTask(int chainId, NulsHash hash) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        DelayQueue<TxGroupTask> remove = map.get(chainId).remove(hash.toHex());
    }

    @Override
    protected void process(int chainId, ChainContext context, NulsLogger logger) {
        Map<String, DelayQueue<TxGroupTask>> delayQueueMap = map.get(chainId);
        ArrayList<String> del = new ArrayList<String>();
        for (Map.Entry<String, DelayQueue<TxGroupTask>> entry : delayQueueMap.entrySet()) {
            String blockHash = entry.getKey();
            TxGroupTask task = (TxGroupTask)entry.getValue().poll();
            if (task == null) continue;
            HashListMessage hashListMessage = task.getRequest();
            List hashList = hashListMessage.getTxHashList();
            int original = hashList.size();
            List<Transaction> existTransactions = TransactionCall.getTransactions(chainId, hashList, false);
            List existHashes = existTransactions.stream().map(Transaction::getHash).collect(Collectors.toList());
            hashList = CollectionUtils.removeAll(hashList, existHashes);
            int filtered = hashList.size();
            CachedSmallBlock cachedSmallBlock = SmallBlockCacher.getCachedSmallBlock(chainId, NulsHash.fromHex((String)blockHash));
            if (cachedSmallBlock == null) continue;
            if (filtered == 0) {
                SmallBlock smallBlock = cachedSmallBlock.getSmallBlock();
                BlockHeader header = smallBlock.getHeader();
                Map<NulsHash, Transaction> txMap = cachedSmallBlock.getTxMap();
                for (Transaction tx : existTransactions) {
                    txMap.put(tx.getHash(), tx);
                }
                Block block = BlockUtil.assemblyBlock(header, txMap, smallBlock.getTxHashList());
                block.setNodeId(cachedSmallBlock.getNodeId());
                TxGroupRequestor.removeTask(chainId, header.getHash());
                logger.debug("record recv block, block create time-" + DateUtils.timeStamp2DateStr((long)(block.getHeader().getTime() * 1000L)) + ", hash-" + block.getHeader().getHash());
                boolean b = this.blockService.saveBlock(chainId, block, 1, true, false, true);
                if (!b) {
                    SmallBlockCacher.setStatus(chainId, header.getHash(), BlockForwardEnum.ERROR);
                }
                del.add(blockHash);
                continue;
            }
            hashListMessage.setTxHashList(hashList);
            if (original != filtered) {
                entry.getValue().forEach(e -> e.setRequest(hashListMessage));
                Map<NulsHash, Transaction> map = cachedSmallBlock.getTxMap();
                existTransactions.forEach(e -> map.put(e.getHash(), (Transaction)e));
            }
            boolean b = NetworkCall.sendToNode(chainId, hashListMessage, task.getNodeId(), "getTxs");
            logger.debug("TxGroupRequestor send getTxgroupMessage to " + task.getNodeId() + ", result-" + b + ", blockHash-" + blockHash);
        }
        del.forEach(delayQueueMap::remove);
    }
}

