/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.utils;

import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.ChainTypeEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.Chain;
import io.nuls.block.service.BlockService;
import io.nuls.common.ConfigBean;
import java.util.ArrayDeque;

public class ChainGenerator {
    public static Chain newChain(long startHeight, long endHeight, String symbol, Chain parent, String parentSymbol, int chainId, ChainTypeEnum type) {
        Chain chain = new Chain();
        chain.setType(type);
        chain.setChainId(chainId);
        chain.setStartHeight(startHeight);
        chain.setEndHeight(endHeight);
        chain.setParent(parent);
        ArrayDeque<NulsHash> hashList = new ArrayDeque<NulsHash>();
        for (long i = startHeight; i <= endHeight; ++i) {
            hashList.add(NulsHash.calcHash((byte[])(symbol + i).getBytes()));
        }
        chain.setHashList(hashList);
        if (parent != null) {
            parent.getSons().add(chain);
        }
        chain.setStartHashCode(hashList.getFirst().hashCode());
        chain.setPreviousHash(NulsHash.calcHash((byte[])(parentSymbol + (startHeight - 1L)).getBytes()));
        return chain;
    }

    public static Chain newMasterChain(long endHeight, String symbol, int chainId) {
        Chain chain = new Chain();
        chain.setType(ChainTypeEnum.MASTER);
        chain.setChainId(chainId);
        chain.setEndHeight(endHeight);
        ArrayDeque<NulsHash> hashList = new ArrayDeque<NulsHash>();
        for (long i = 0L; i <= endHeight; ++i) {
            hashList.add(NulsHash.calcHash((byte[])(symbol + i).getBytes()));
        }
        chain.setHashList(hashList);
        chain.setStartHashCode(hashList.getFirst().hashCode());
        chain.setPreviousHash(NulsHash.calcHash((byte[])(symbol + "-1").getBytes()));
        return chain;
    }

    public static Chain generate(int chainId, Block block, Chain parent, ChainTypeEnum type) {
        BlockHeader header = block.getHeader();
        long height = header.getHeight();
        NulsHash hash = header.getHash();
        NulsHash preHash = header.getPreHash();
        Chain chain = new Chain();
        ArrayDeque<NulsHash> hashs = new ArrayDeque<NulsHash>();
        hashs.add(hash);
        chain.setChainId(chainId);
        chain.setStartHeight(height);
        chain.setEndHeight(height);
        chain.setHashList(hashs);
        chain.setPreviousHash(preHash);
        chain.setParent(parent);
        chain.setType(type);
        chain.setStartHashCode(header.getHash().hashCode());
        if (parent != null) {
            parent.getSons().add(chain);
        }
        return chain;
    }

    public static Chain generateMasterChain(int chainId, Block block, BlockService blockService) {
        BlockHeader header = block.getHeader();
        long height = header.getHeight();
        Chain chain = new Chain();
        chain.setChainId(chainId);
        chain.setStartHeight(0L);
        chain.setEndHeight(height);
        chain.setType(ChainTypeEnum.MASTER);
        chain.setParent(null);
        chain.setPreviousHash(header.getPreHash());
        chain.setStartHashCode(header.getHash().hashCode());
        ArrayDeque<NulsHash> hashs = new ArrayDeque<NulsHash>();
        ConfigBean parameters = ContextManager.getContext(chainId).getParameters();
        int heightRange = parameters.getHeightRange();
        long start = height - (long)heightRange + 1L;
        for (long i = start = start >= 0L ? start : 0L; i <= height; ++i) {
            hashs.add(blockService.getBlockHash(chainId, i));
        }
        chain.setHashList(hashs);
        return chain;
    }
}

