/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.utils;

import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.SmallBlock;
import io.nuls.base.data.Transaction;
import io.nuls.block.constant.BlockForwardEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.CachedSmallBlock;
import io.nuls.block.service.BlockService;
import io.nuls.block.utils.BlockUtil;
import io.nuls.common.ConfigBean;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class SmallBlockCacher {
    @Autowired
    private static BlockService service;
    private static Map<Integer, Map<NulsHash, CachedSmallBlock>> smallBlockCacheMap;
    private static Map<Integer, Map<NulsHash, BlockForwardEnum>> statusCacheMap;

    public static void cacheSmallBlock(int chainId, CachedSmallBlock cachedSmallBlock) {
        SmallBlock smallBlock = cachedSmallBlock.getSmallBlock();
        smallBlockCacheMap.get(chainId).put(smallBlock.getHeader().getHash(), cachedSmallBlock);
    }

    public static CachedSmallBlock getCachedSmallBlock(int chainId, NulsHash blockHash) {
        CachedSmallBlock cachedSmallBlock = smallBlockCacheMap.get(chainId).get(blockHash);
        if (cachedSmallBlock == null) {
            Block block = service.getBlock(chainId, blockHash);
            if (block == null) {
                return null;
            }
            SmallBlock smallBlock = BlockUtil.getSmallBlock(chainId, block);
            List txs = block.getTxs();
            HashMap<NulsHash, Transaction> txMap = new HashMap<NulsHash, Transaction>(txs.size());
            txs.forEach(e -> txMap.put(e.getHash(), (Transaction)e));
            cachedSmallBlock = new CachedSmallBlock(null, smallBlock, txMap, null);
        }
        return cachedSmallBlock;
    }

    public static SmallBlock getSmallBlock(int chainId, NulsHash blockHash) {
        CachedSmallBlock cachedSmallBlock = SmallBlockCacher.getCachedSmallBlock(chainId, blockHash);
        if (cachedSmallBlock == null) {
            return null;
        }
        return cachedSmallBlock.getSmallBlock();
    }

    public static BlockForwardEnum getStatus(int chainId, NulsHash blockHash) {
        Map<NulsHash, BlockForwardEnum> map = statusCacheMap.get(chainId);
        return map.computeIfAbsent(blockHash, k -> BlockForwardEnum.EMPTY);
    }

    public static void setStatus(int chainId, NulsHash blockHash, BlockForwardEnum blockForwardEnum) {
        statusCacheMap.get(chainId).put(blockHash, blockForwardEnum);
    }

    public static void init(int chainId) {
        ConfigBean parameters = ContextManager.getContext(chainId).getParameters();
        byte config = parameters.getSmallBlockCache();
        Map map = CollectionUtils.getSynSizedMap((int)config);
        smallBlockCacheMap.put(chainId, map);
        Map statusMap = CollectionUtils.getSynSizedMap((int)config);
        statusCacheMap.put(chainId, statusMap);
    }

    static {
        smallBlockCacheMap = new ConcurrentHashMap<Integer, Map<NulsHash, CachedSmallBlock>>();
        statusCacheMap = new ConcurrentHashMap<Integer, Map<NulsHash, BlockForwardEnum>>();
    }
}

