/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.protocol.CommonAdvice;
import io.nuls.base.protocol.cmd.TransactionDispatcher;
import io.nuls.chain.info.CmConstants;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.rpc.call.RpcService;
import io.nuls.chain.rpc.call.impl.RpcServiceImpl;
import io.nuls.chain.service.CacheDataService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.service.impl.ChainServiceImpl;
import io.nuls.chain.service.tx.v1.ChainAssetCommitAdvice;
import io.nuls.chain.service.tx.v1.ChainAssetRollbackAdvice;
import io.nuls.chain.storage.InitDB;
import io.nuls.chain.storage.impl.AssetStorageImpl;
import io.nuls.chain.storage.impl.BlockHeightStorageImpl;
import io.nuls.chain.storage.impl.CacheDatasStorageImpl;
import io.nuls.chain.storage.impl.ChainAssetStorageImpl;
import io.nuls.chain.storage.impl.ChainCirculateStorageImpl;
import io.nuls.chain.storage.impl.ChainStorageImpl;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class ChainManagerBootstrap
implements INulsCoresBootstrap {
    @Autowired
    private NulsCoresConfig nulsChainConfig;
    @Autowired
    private AddressPrefixDatas addressPrefixDatas;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private ChainService chainService;

    @Override
    public int order() {
        return 6;
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    private void initCfg() throws Exception {
        CmRuntimeInfo.nulsAssetId = String.valueOf(this.nulsChainConfig.getMainAssetId());
        CmRuntimeInfo.nulsChainId = String.valueOf(this.nulsChainConfig.getMainChainId());
        long decimal = (long)Math.pow(10.0, Integer.valueOf(this.nulsChainConfig.getDefaultDecimalPlaces()).intValue());
        BigInteger initNumber = BigIntegerUtils.stringToBigInteger((String)this.nulsChainConfig.getNulsAssetInitNumberMax()).multiply(BigInteger.valueOf(decimal));
        this.nulsChainConfig.setNulsAssetInitNumberMax(BigIntegerUtils.bigIntegerToString((BigInteger)initNumber));
        BigInteger assetDepositNuls = this.nulsChainConfig.getAssetDepositNuls().multiply(BigInteger.valueOf(decimal));
        this.nulsChainConfig.setAssetDepositNuls(assetDepositNuls);
        this.nulsChainConfig.setAssetDepositNulsLockRate(String.valueOf(1.0 - Double.valueOf(this.nulsChainConfig.getAssetDepositNulsDestroyRate())));
        int rateToPercent = new BigDecimal(this.nulsChainConfig.getAssetDepositNulsDestroyRate()).multiply(BigDecimal.valueOf(100L)).intValue();
        this.nulsChainConfig.setAssetDestroyNuls(this.nulsChainConfig.getAssetDepositNuls().multiply(BigInteger.valueOf(rateToPercent)).divide(BigInteger.valueOf(100L)));
        BigInteger assetInitNumberMin = BigIntegerUtils.stringToBigInteger((String)this.nulsChainConfig.getAssetInitNumberMin()).multiply(BigInteger.valueOf(decimal));
        this.nulsChainConfig.setAssetInitNumberMin(BigIntegerUtils.bigIntegerToString((BigInteger)assetInitNumberMin));
        BigInteger assetInitNumberMax = BigIntegerUtils.stringToBigInteger((String)this.nulsChainConfig.getAssetInitNumberMax()).multiply(BigInteger.valueOf(decimal));
        this.nulsChainConfig.setAssetInitNumberMax(BigIntegerUtils.bigIntegerToString((BigInteger)assetInitNumberMax));
        this.nulsChainConfig.setNulsFeeMainNetPercent((int)(Double.valueOf(this.nulsChainConfig.getNulsFeeMainNetRate()) * 100.0));
        this.nulsChainConfig.setNulsFeeOtherNetPercent(100 - this.nulsChainConfig.getNulsFeeMainNetPercent());
        CmConstants.BLACK_HOLE_ADDRESS = AddressTool.getAddressByPubKeyStr((String)this.nulsChainConfig.getBlackHolePublicKey(), (int)CmRuntimeInfo.getMainIntChainId());
        LoggerUtil.defaultLogInit(CmRuntimeInfo.getMainIntChainId());
    }

    private void initWithDatabase() throws Exception {
        RocksDBService.init((String)(this.nulsChainConfig.getDataPath() + File.separator + ModuleE.CM.name));
        InitDB assetStorage = (InitDB)SpringLiteContext.getBean(AssetStorageImpl.class);
        assetStorage.initTableName();
        LoggerUtil.logger().info("assetStorage.init complete.....");
        InitDB blockHeightStorage = (InitDB)SpringLiteContext.getBean(BlockHeightStorageImpl.class);
        blockHeightStorage.initTableName();
        LoggerUtil.logger().info("blockHeightStorage.init complete.....");
        InitDB cacheDatasStorage = (InitDB)SpringLiteContext.getBean(CacheDatasStorageImpl.class);
        cacheDatasStorage.initTableName();
        LoggerUtil.logger().info("cacheDatasStorage.init complete.....");
        InitDB chainAssetStorage = (InitDB)SpringLiteContext.getBean(ChainAssetStorageImpl.class);
        chainAssetStorage.initTableName();
        LoggerUtil.logger().info("chainAssetStorage.init complete.....");
        InitDB chainStorage = (InitDB)SpringLiteContext.getBean(ChainStorageImpl.class);
        chainStorage.initTableName();
        LoggerUtil.logger().info("chainStorage.init complete.....");
        InitDB chainCirculateStorage = (InitDB)SpringLiteContext.getBean(ChainCirculateStorageImpl.class);
        chainCirculateStorage.initTableName();
        LoggerUtil.logger().info("chainCirculateStorage.init complete.....");
    }

    private void initMainChain() throws Exception {
        ((ChainService)SpringLiteContext.getBean(ChainService.class)).initMainChain();
    }

    private void initChainDatas() throws Exception {
        ((CacheDataService)SpringLiteContext.getBean(CacheDataService.class)).initBlockDatas();
        ChainServiceImpl chainService = (ChainServiceImpl)SpringLiteContext.getBean(ChainServiceImpl.class);
        RpcServiceImpl rpcService = (RpcServiceImpl)SpringLiteContext.getBean(RpcServiceImpl.class);
        long mainNetMagicNumber = rpcService.getMainNetMagicNumber();
        chainService.initRegChainDatas(mainNetMagicNumber);
        LoggerUtil.logger().info("initChainDatas complete....");
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.CM.abbr, "1.0");
    }

    public void init() {
        try {
            this.initCfg();
            LoggerUtil.logger().info("initCfg complete.....");
            this.initWithDatabase();
            LoggerUtil.logger().info("initWithDatabase complete.....");
            this.initMainChain();
            LoggerUtil.logger().info("initMainChain complete.....");
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            LoggerUtil.logger().error("Exit due to initialization exception....");
            System.exit(-1);
        }
    }

    private boolean doStart() {
        TransactionDispatcher transactionDispatcher = (TransactionDispatcher)SpringLiteContext.getBean(TransactionDispatcher.class);
        CommonAdvice commitAdvice = (CommonAdvice)SpringLiteContext.getBean(ChainAssetCommitAdvice.class);
        CommonAdvice rollbackAdvice = (CommonAdvice)SpringLiteContext.getBean(ChainAssetRollbackAdvice.class);
        transactionDispatcher.register(ModuleE.CM, commitAdvice, rollbackAdvice);
        LoggerUtil.logger().info("doStart ok....");
        return true;
    }

    @Override
    public void onDependenciesReady() {
        try {
            this.doStart();
            try {
                this.initChainDatas();
            }
            catch (Exception e) {
                LoggerUtil.logger().error(e);
                LoggerUtil.logger().error("Start abnormal exit....");
                System.exit(-1);
            }
            try {
                List<BlockChain> blockChains = this.chainService.getBlockList();
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (BlockChain blockChain : blockChains) {
                    if (blockChain.getChainId() == Integer.valueOf(this.nulsChainConfig.getMainChainId()).intValue()) continue;
                    HashMap<String, Object> prefix = new HashMap<String, Object>();
                    prefix.put("chainId", blockChain.getChainId());
                    prefix.put("addressPrefix", blockChain.getAddressPrefix());
                    list.add(prefix);
                }
                this.rpcService.addAcAddressPrefix(list);
            }
            catch (Exception e) {
                LoggerUtil.logger().error(e);
            }
            LoggerUtil.logger().info("onDependenciesReady ok....");
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            System.exit(-1);
        }
    }
}

