/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.model.po;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.chain.model.tx.txdatav5.TxAsset;
import io.nuls.chain.model.tx.txdatav5.TxChain;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Asset
extends BaseNulsData {
    private int chainId = 0;
    private int assetId = 0;
    private String symbol;
    private String assetName;
    private BigInteger depositNuls = BigInteger.ZERO;
    private BigInteger destroyNuls = BigInteger.ZERO;
    private BigInteger initNumber = BigInteger.ZERO;
    private short decimalPlaces = (short)8;
    private boolean available = true;
    private long createTime = 0L;
    private long lastUpdateTime = 0L;
    private byte[] address;
    private String txHash;
    List<Integer> chainIds = new ArrayList<Integer>();

    public void addChainId(int chainId) {
        this.chainIds.add(chainId);
    }

    public Asset(TxChain tx, BigInteger depositNuls, BigInteger destroyNuls, byte[] address) {
        TxAsset defaultAsset = tx.getDefaultAsset();
        this.address = address;
        this.assetId = defaultAsset.getAssetId();
        this.chainId = defaultAsset.getChainId();
        this.decimalPlaces = defaultAsset.getDecimalPlaces();
        this.depositNuls = depositNuls;
        this.destroyNuls = destroyNuls;
        this.initNumber = defaultAsset.getInitNumber();
        this.symbol = defaultAsset.getSymbol();
        this.assetName = defaultAsset.getName();
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.writeUint16(this.assetId);
        stream.writeString(this.symbol);
        stream.writeString(this.assetName);
        stream.writeBigInteger(this.depositNuls);
        stream.writeBigInteger(this.destroyNuls);
        stream.writeBigInteger(this.initNumber);
        stream.writeShort(this.decimalPlaces);
        stream.writeBoolean(this.available);
        stream.writeUint32(this.createTime);
        stream.writeUint32(this.lastUpdateTime);
        stream.writeBytesWithLength(this.address);
        stream.writeString(this.txHash);
        int chainIdsSize = this.chainIds == null ? 0 : this.chainIds.size();
        stream.writeVarInt(chainIdsSize);
        if (null != this.chainIds) {
            for (int chainId : this.chainIds) {
                stream.writeUint16(chainId);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readUint16();
        this.assetId = byteBuffer.readUint16();
        this.symbol = byteBuffer.readString();
        this.assetName = byteBuffer.readString();
        this.depositNuls = byteBuffer.readBigInteger();
        this.destroyNuls = byteBuffer.readBigInteger();
        this.initNumber = byteBuffer.readBigInteger();
        this.decimalPlaces = byteBuffer.readShort();
        this.available = byteBuffer.readBoolean();
        this.createTime = byteBuffer.readUint32();
        this.lastUpdateTime = byteBuffer.readUint32();
        this.address = byteBuffer.readByLengthByte();
        this.txHash = byteBuffer.readString();
        int chainIdSize = (int)byteBuffer.readVarInt();
        if (0 < chainIdSize) {
            for (int i = 0; i < chainIdSize; ++i) {
                int chainId = byteBuffer.readUint16();
                this.chainIds.add(chainId);
            }
        }
    }

    public Asset(int assetId) {
        this.assetId = assetId;
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfString((String)this.symbol);
        size += SerializeUtils.sizeOfString((String)this.assetName);
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfInt16();
        size += SerializeUtils.sizeOfBoolean();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBytes((byte[])this.address);
        size += SerializeUtils.sizeOfString((String)this.txHash);
        size += SerializeUtils.sizeOfVarInt((Integer)(this.chainIds == null ? 0 : this.chainIds.size()));
        if (null != this.chainIds) {
            size += SerializeUtils.sizeOfUint16() * this.chainIds.size();
        }
        return size;
    }

    public Asset() {
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public BigInteger getDepositNuls() {
        return this.depositNuls;
    }

    public void setDepositNuls(BigInteger depositNuls) {
        this.depositNuls = depositNuls;
    }

    public BigInteger getDestroyNuls() {
        return this.destroyNuls;
    }

    public void setDestroyNuls(BigInteger destroyNuls) {
        this.destroyNuls = destroyNuls;
    }

    public BigInteger getInitNumber() {
        return this.initNumber;
    }

    public void setInitNumber(BigInteger initNumber) {
        this.initNumber = initNumber;
    }

    public short getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(short decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public List<Integer> getChainIds() {
        return this.chainIds;
    }

    public void setChainIds(List<Integer> chainIds) {
        this.chainIds = chainIds;
    }

    public void map2pojo(Map<String, Object> map) {
        this.setChainId(Integer.valueOf(map.get("chainId").toString()));
        this.setAssetId(Integer.valueOf(map.get("assetId").toString()));
        this.setSymbol(String.valueOf(map.get("symbol")));
        this.setAssetName(String.valueOf(map.get("assetName")));
        this.setDecimalPlaces(Short.valueOf(map.get("decimalPlaces").toString()));
        long decimal = (long)Math.pow(10.0, Integer.valueOf(this.getDecimalPlaces()).intValue());
        BigInteger initNumber = new BigInteger(String.valueOf(map.get("initNumber"))).multiply(BigInteger.valueOf(decimal));
        this.setInitNumber(initNumber);
        this.setCreateTime(NulsDateUtils.getCurrentTimeSeconds());
        this.setAddress(AddressTool.getAddress((String)map.get("address").toString()));
    }
}

