/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;

public class ChainAsset
extends BaseNulsData {
    private int addressChainId;
    private int assetChainId;
    private int assetId;
    private BigInteger initNumber = BigInteger.ZERO;
    private BigInteger inNumber = BigInteger.ZERO;
    private BigInteger outNumber = BigInteger.ZERO;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.addressChainId);
        stream.writeUint16(this.assetChainId);
        stream.writeUint16(this.assetId);
        stream.writeBigInteger(this.initNumber);
        stream.writeBigInteger(this.inNumber);
        stream.writeBigInteger(this.outNumber);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.addressChainId = byteBuffer.readUint16();
        this.assetChainId = byteBuffer.readUint16();
        this.assetId = byteBuffer.readUint16();
        this.initNumber = byteBuffer.readBigInteger();
        this.inNumber = byteBuffer.readBigInteger();
        this.outNumber = byteBuffer.readBigInteger();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfBigInteger();
        return size += SerializeUtils.sizeOfBigInteger();
    }

    public int getAddressChainId() {
        return this.addressChainId;
    }

    public void setAddressChainId(int addressChainId) {
        this.addressChainId = addressChainId;
    }

    public int getAssetChainId() {
        return this.assetChainId;
    }

    public void setAssetChainId(int assetChainId) {
        this.assetChainId = assetChainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public BigInteger getInitNumber() {
        return this.initNumber;
    }

    public void setInitNumber(BigInteger initNumber) {
        this.initNumber = initNumber;
    }

    public BigInteger getInNumber() {
        return this.inNumber;
    }

    public void setInNumber(BigInteger inNumber) {
        this.inNumber = inNumber;
    }

    public BigInteger getOutNumber() {
        return this.outNumber;
    }

    public void setOutNumber(BigInteger outNumber) {
        this.outNumber = outNumber;
    }

    public boolean isFromChainAsset() {
        return this.addressChainId == this.assetChainId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"addressChainId\":").append(this.addressChainId);
        sb.append(",\"assetChainId\":").append(this.assetChainId);
        sb.append(",\"assetId\":").append(this.assetId);
        sb.append(",\"initNumber\":").append(this.initNumber);
        sb.append(",\"inNumber\":").append(this.inNumber);
        sb.append(",\"outNumber\":").append(this.outNumber);
        sb.append('}');
        return sb.toString();
    }
}

