/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.impl;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.model.po.BlockHeight;
import io.nuls.chain.model.po.CacheDatas;
import io.nuls.chain.model.po.ChainAsset;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.CacheDataService;
import io.nuls.chain.storage.AssetStorage;
import io.nuls.chain.storage.BlockHeightStorage;
import io.nuls.chain.storage.CacheDatasStorage;
import io.nuls.chain.storage.ChainAssetStorage;
import io.nuls.chain.storage.ChainStorage;
import io.nuls.chain.util.ChainManagerUtil;
import io.nuls.chain.util.TxUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Service;
import io.nuls.core.exception.NulsException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CacheDataServiceImpl
implements CacheDataService {
    @Autowired
    BlockHeightStorage blockHeightStorage;
    @Autowired
    CacheDatasStorage cacheDatasStorage;
    @Autowired
    ChainStorage chainStorage;
    @Autowired
    ChainAssetStorage chainAssetStorage;
    @Autowired
    AssetService assetService;
    @Autowired
    AssetStorage assetStorage;

    @Override
    public void initBlockDatas() throws Exception {
        BlockHeight blockHeight = this.blockHeightStorage.getBlockHeight(CmRuntimeInfo.getMainIntChainId());
        if (null != blockHeight && !blockHeight.isCommit()) {
            CacheDatas cacheDatas = this.cacheDatasStorage.load(blockHeight.getBlockHeight() - 1L);
            if (null != cacheDatas) {
                this.rollDatas(cacheDatas.getBlockChains(), cacheDatas.getAssets(), cacheDatas.getChainAssets());
            }
            blockHeight.setBlockHeight(blockHeight.getBlockHeight() - 1L);
            blockHeight.setCommit(true);
            this.blockHeightStorage.saveOrUpdateBlockHeight(CmRuntimeInfo.getMainIntChainId(), blockHeight);
        }
    }

    public void rollDatas(List<BlockChain> blockChains, List<Asset> assets, List<ChainAsset> chainAssets) throws Exception {
        for (BlockChain blockChain : blockChains) {
            this.chainStorage.update(blockChain.getChainId(), blockChain);
        }
        for (Asset asset : assets) {
            this.assetStorage.save(CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()), asset);
        }
        for (ChainAsset chainAsset : chainAssets) {
            String assetKey = CmRuntimeInfo.getAssetKey(chainAsset.getAssetChainId(), chainAsset.getAssetId());
            this.chainAssetStorage.save(CmRuntimeInfo.getChainAssetKey(chainAsset.getAddressChainId(), assetKey), chainAsset);
        }
    }

    @Override
    public void bakBlockTxs(int chainId, long height, List<Transaction> txList, boolean isCirculate) throws Exception {
        HashMap<String, Integer> blockChains = new HashMap<String, Integer>();
        HashMap<String, Integer> assets = new HashMap<String, Integer>();
        HashMap<String, Integer> chainAssets = new HashMap<String, Integer>();
        long preHeight = height - 1L;
        CacheDatas moduleTxDatas = this.cacheDatasStorage.load(preHeight);
        if (null != moduleTxDatas) {
            return;
        }
        moduleTxDatas = new CacheDatas();
        if (isCirculate) {
            this.buildCirculateDatas(txList, blockChains, assets, chainAssets);
        } else {
            this.buildDatas(txList, blockChains, assets, chainAssets);
        }
        for (Map.Entry entry : blockChains.entrySet()) {
            BlockChain blockChain = this.chainStorage.load(Integer.valueOf((String)entry.getKey()));
            moduleTxDatas.addBlockChain(blockChain);
        }
        for (Map.Entry entry : assets.entrySet()) {
            Asset asset = this.assetStorage.load((String)entry.getKey());
            moduleTxDatas.addAsset(asset);
        }
        for (Map.Entry entry : chainAssets.entrySet()) {
            ChainAsset chainAsset = this.assetService.getChainAsset((String)entry.getKey());
            moduleTxDatas.addChainAsset(chainAsset);
        }
        this.cacheDatasStorage.save(height, moduleTxDatas);
    }

    private void buildCirculateDatas(List<Transaction> txList, Map<String, Integer> blockChains, Map<String, Integer> assets, Map<String, Integer> chainAssets) throws NulsException {
        for (Transaction tx : txList) {
            int fromChainId = 0;
            int toChainId = 0;
            CoinData coinData = new CoinData();
            coinData.parse(tx.getCoinData(), 0);
            List listFrom = coinData.getFrom();
            for (CoinFrom coinFrom : listFrom) {
                fromChainId = AddressTool.getChainIdByAddress((byte[])coinFrom.getAddress());
                String assetKey = CmRuntimeInfo.getAssetKey(coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
                blockChains.put(String.valueOf(fromChainId), 1);
                chainAssets.put(CmRuntimeInfo.getChainAssetKey(fromChainId, assetKey), 1);
            }
            List listTo = coinData.getTo();
            for (CoinTo coinTo : listTo) {
                toChainId = AddressTool.getChainIdByAddress((byte[])coinTo.getAddress());
                int assetChainId = coinTo.getAssetsChainId();
                int assetId = coinTo.getAssetsId();
                String assetKey = CmRuntimeInfo.getAssetKey(assetChainId, assetId);
                blockChains.put(String.valueOf(toChainId), 1);
                chainAssets.put(CmRuntimeInfo.getChainAssetKey(toChainId, assetKey), 1);
                assets.put(assetKey, 1);
            }
            assets.put(CmRuntimeInfo.getMainAssetKey(), 1);
            chainAssets.put(CmRuntimeInfo.getMainChainAssetKey(), 1);
            blockChains.put(CmRuntimeInfo.getMainChainId(), 1);
        }
    }

    private void buildDatas(List<Transaction> txList, Map<String, Integer> blockChains, Map<String, Integer> assets, Map<String, Integer> chainAssets) {
        for (Transaction tx : txList) {
            switch (tx.getType()) {
                case 11: {
                    BlockChain blockChain = null;
                    Asset asset = null;
                    if (ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5) {
                        blockChain = TxUtil.buildChainWithTxDataV4(tx, false);
                        asset = TxUtil.buildAssetWithTxChainV4(tx);
                    } else {
                        blockChain = TxUtil.buildChainWithTxData(tx, false);
                        asset = TxUtil.buildAssetWithTxChain(tx);
                    }
                    blockChains.put(String.valueOf(blockChain.getChainId()), 1);
                    String assetKey = CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId());
                    String key = CmRuntimeInfo.getChainAssetKey(asset.getChainId(), assetKey);
                    assets.put(assetKey, 1);
                    chainAssets.put(key, 1);
                    break;
                }
                case 12: {
                    BlockChain delBlockChain = null;
                    delBlockChain = ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5 ? TxUtil.buildChainWithTxDataV4(tx, true) : TxUtil.buildChainWithTxData(tx, true);
                    blockChains.put(String.valueOf(delBlockChain.getChainId()), 1);
                    break;
                }
                case 13: {
                    Asset addAsset = null;
                    addAsset = ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5 ? TxUtil.buildAssetWithTxAssetV5(tx) : TxUtil.buildAssetWithTxAsset(tx);
                    assets.put(CmRuntimeInfo.getAssetKey(addAsset.getChainId(), addAsset.getAssetId()), 1);
                    chainAssets.put(CmRuntimeInfo.getChainAssetKey(addAsset.getChainId(), CmRuntimeInfo.getAssetKey(addAsset.getChainId(), addAsset.getAssetId())), 1);
                    break;
                }
                case 14: {
                    Asset delAsset = null;
                    delAsset = ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5 ? TxUtil.buildAssetWithTxAssetV5(tx) : TxUtil.buildAssetWithTxAsset(tx);
                    assets.put(CmRuntimeInfo.getAssetKey(delAsset.getChainId(), delAsset.getAssetId()), 1);
                    chainAssets.put(CmRuntimeInfo.getChainAssetKey(delAsset.getChainId(), CmRuntimeInfo.getAssetKey(delAsset.getChainId(), delAsset.getAssetId())), 1);
                    break;
                }
            }
        }
    }

    @Override
    public void rollBlockTxs(int chainId, long height) throws Exception {
        BlockHeight saveBlockHeight = this.blockHeightStorage.getBlockHeight(chainId);
        if (null == saveBlockHeight) {
            return;
        }
        saveBlockHeight.setCommit(false);
        this.blockHeightStorage.saveOrUpdateBlockHeight(chainId, saveBlockHeight);
        CacheDatas moduleTxDatas = this.cacheDatasStorage.load(height - 1L);
        if (null != moduleTxDatas) {
            for (BlockChain blockChain : moduleTxDatas.getBlockChains()) {
                this.chainStorage.update(blockChain.getChainId(), blockChain);
            }
            for (Asset asset : moduleTxDatas.getAssets()) {
                this.assetStorage.save(CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()), asset);
            }
            for (ChainAsset chainAsset : moduleTxDatas.getChainAssets()) {
                String assetKey = CmRuntimeInfo.getAssetKey(chainAsset.getAssetChainId(), chainAsset.getAssetId());
                this.chainAssetStorage.save(CmRuntimeInfo.getChainAssetKey(chainAsset.getAddressChainId(), assetKey), chainAsset);
            }
        }
        saveBlockHeight.setBlockHeight(height - 1L);
        saveBlockHeight.setCommit(true);
        this.blockHeightStorage.saveOrUpdateBlockHeight(chainId, saveBlockHeight);
        this.cacheDatasStorage.delete(height - 1L);
    }

    @Override
    public CacheDatas getCacheDatas(long height) throws Exception {
        return this.cacheDatasStorage.load(height);
    }

    @Override
    public BlockHeight getBlockHeight(int chainId) throws Exception {
        BlockHeight blockHeight = this.blockHeightStorage.getBlockHeight(chainId);
        if (null == blockHeight) {
            return new BlockHeight();
        }
        return blockHeight;
    }

    @Override
    public void beginBakBlockHeight(int chainId, long blockHeight) throws Exception {
        BlockHeight saveBlockHeight = this.blockHeightStorage.getBlockHeight(chainId);
        if (null == saveBlockHeight) {
            saveBlockHeight = new BlockHeight();
        }
        saveBlockHeight.setCommit(false);
        saveBlockHeight.setBlockHeight(blockHeight);
        this.blockHeightStorage.saveOrUpdateBlockHeight(chainId, saveBlockHeight);
    }

    @Override
    public void endBakBlockHeight(int chainId, long blockHeight) throws Exception {
        BlockHeight saveBlockHeight = this.blockHeightStorage.getBlockHeight(chainId);
        saveBlockHeight.setCommit(true);
        this.blockHeightStorage.saveOrUpdateBlockHeight(chainId, saveBlockHeight);
    }
}

