/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.impl;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.ChainEventResult;
import io.nuls.chain.model.dto.CoinDataAssets;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.model.po.ChainAsset;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.service.TxCirculateService;
import io.nuls.chain.storage.ChainAssetStorage;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Service;
import io.nuls.core.exception.NulsException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
public class TxCirculateServiceImpl
implements TxCirculateService {
    @Autowired
    AssetService assetService;
    @Autowired
    ChainService chainService;
    @Autowired
    ChainAssetStorage chainAssetStorage;
    @Autowired
    NulsCoresConfig nulsChainConfig;

    @Override
    public List<CoinDataAssets> getChainAssetList(byte[] coinDataByte) throws NulsException {
        ArrayList<CoinDataAssets> list = new ArrayList<CoinDataAssets>();
        int fromChainId = 0;
        int toChainId = 0;
        HashMap<String, BigInteger> fromAssetMap = new HashMap<String, BigInteger>(2);
        HashMap<String, BigInteger> toAssetMap = new HashMap<String, BigInteger>(2);
        CoinData coinData = new CoinData();
        coinData.parse(coinDataByte, 0);
        List listFrom = coinData.getFrom();
        for (Object coinFrom : listFrom) {
            fromChainId = AddressTool.getChainIdByAddress((byte[])coinFrom.getAddress());
            String assetKey = CmRuntimeInfo.getAssetKey(coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
            BigInteger amount = coinFrom.getAmount();
            BigInteger current = (BigInteger)fromAssetMap.get(assetKey);
            if (current != null) {
                amount = amount.add(current);
            }
            fromAssetMap.put(assetKey, amount);
        }
        List listTo = coinData.getTo();
        for (CoinTo coinTo : listTo) {
            toChainId = AddressTool.getChainIdByAddress((byte[])coinTo.getAddress());
            int assetChainId = coinTo.getAssetsChainId();
            int assetId = coinTo.getAssetsId();
            String assetKey = CmRuntimeInfo.getAssetKey(assetChainId, assetId);
            BigInteger amount = coinTo.getAmount();
            BigInteger current = (BigInteger)toAssetMap.get(assetKey);
            if (current != null) {
                amount = amount.add(current);
            }
            toAssetMap.put(assetKey, amount);
        }
        CoinDataAssets fromCoinDataAssets = new CoinDataAssets();
        fromCoinDataAssets.setChainId(fromChainId);
        fromCoinDataAssets.setAssetsMap(fromAssetMap);
        list.add(fromCoinDataAssets);
        CoinDataAssets toCoinDataAssets = new CoinDataAssets();
        toCoinDataAssets.setChainId(toChainId);
        toCoinDataAssets.setAssetsMap(toAssetMap);
        list.add(toCoinDataAssets);
        return list;
    }

    @Override
    public ChainAsset getCirculateChainAsset(int circulateChainId, int assetChainId, int assetId) throws Exception {
        String assetKey = CmRuntimeInfo.getAssetKey(assetChainId, assetId);
        ChainAsset chainAsset = this.assetService.getChainAsset(circulateChainId, assetKey);
        return chainAsset;
    }

    boolean isMainChain(int chainId) {
        return CmRuntimeInfo.getMainIntChainId() == chainId;
    }

    @Override
    public ChainEventResult circulateCommit(List<Transaction> txs) throws Exception {
        HashMap<String, BlockChain> batchUpdateBlockChain = new HashMap<String, BlockChain>();
        HashMap<String, Asset> batchUpdateAsset = new HashMap<String, Asset>();
        HashMap<String, ChainAsset> batchUpdateChainAsset = new HashMap<String, ChainAsset>();
        for (Transaction tx : txs) {
            String key;
            List<CoinDataAssets> list = this.getChainAssetList(tx.getCoinData());
            CoinDataAssets fromCoinDataAssets = list.get(0);
            CoinDataAssets toCoinDataAssets = list.get(1);
            int fromChainId = fromCoinDataAssets.getChainId();
            int toChainId = toCoinDataAssets.getChainId();
            Map<String, BigInteger> fromAssetMap = fromCoinDataAssets.getAssetsMap();
            Map<String, BigInteger> toAssetMap = toCoinDataAssets.getAssetsMap();
            Set<String> assetKeys = fromAssetMap.keySet();
            for (String assetKey : assetKeys) {
                BigInteger currentAsset;
                BigInteger tempAmount;
                ChainAsset fromChainAsset = null;
                key = CmRuntimeInfo.getChainAssetKey(fromChainId, assetKey);
                fromChainAsset = null == batchUpdateChainAsset.get(key) ? this.assetService.getChainAsset(fromChainId, assetKey) : (ChainAsset)((Object)batchUpdateChainAsset.get(key));
                if (assetKey.equalsIgnoreCase(CmRuntimeInfo.getMainAssetKey())) {
                    tempAmount = fromAssetMap.get(assetKey) == null ? BigInteger.ZERO : fromAssetMap.get(assetKey);
                    currentAsset = fromChainAsset.getOutNumber().add(tempAmount);
                    fromChainAsset.setOutNumber(currentAsset);
                } else {
                    tempAmount = toAssetMap.get(assetKey) == null ? BigInteger.ZERO : toAssetMap.get(assetKey);
                    currentAsset = fromChainAsset.getOutNumber().add(tempAmount);
                    fromChainAsset.setOutNumber(currentAsset);
                }
                batchUpdateChainAsset.put(key, fromChainAsset);
            }
            if (!this.isMainChain(toChainId)) {
                String mainAssetKey = CmRuntimeInfo.getMainAssetKey();
                BigInteger allFromMainAmount = fromAssetMap.get(mainAssetKey) == null ? BigInteger.ZERO : fromAssetMap.get(mainAssetKey);
                BigInteger allToMainAmount = toAssetMap.get(mainAssetKey) == null ? BigInteger.ZERO : toAssetMap.get(mainAssetKey);
                BigInteger feeAmount = allFromMainAmount.subtract(allToMainAmount).multiply(BigInteger.valueOf(this.nulsChainConfig.getNulsFeeOtherNetPercent())).divide(BigInteger.valueOf(100L));
                if (null != toAssetMap.get(mainAssetKey)) {
                    feeAmount = feeAmount.add(toAssetMap.get(mainAssetKey));
                }
                toAssetMap.put(mainAssetKey, feeAmount);
            }
            Set<String> toAssetKeys = toAssetMap.keySet();
            for (String toAssetKey : toAssetKeys) {
                key = CmRuntimeInfo.getChainAssetKey(toChainId, toAssetKey);
                ChainAsset toChainAsset = null;
                toChainAsset = null == batchUpdateChainAsset.get(key) ? this.assetService.getChainAsset(toChainId, toAssetKey) : (ChainAsset)((Object)batchUpdateChainAsset.get(key));
                if (null == toChainAsset) {
                    BlockChain toChain = null;
                    Asset asset = null;
                    asset = null != batchUpdateAsset.get(toAssetKey) ? (Asset)((Object)batchUpdateAsset.get(toAssetKey)) : this.assetService.getAsset(toAssetKey);
                    toChain = null != batchUpdateBlockChain.get(String.valueOf(toChainId)) ? (BlockChain)((Object)batchUpdateBlockChain.get(String.valueOf(toChainId))) : this.chainService.getChain(toChainId);
                    toChain.addCirculateAssetId(toAssetKey);
                    asset.addChainId(toChainId);
                    batchUpdateBlockChain.put(String.valueOf(toChainId), toChain);
                    batchUpdateAsset.put(toAssetKey, asset);
                    toChainAsset = new ChainAsset();
                    toChainAsset.setAddressChainId(toChainId);
                    toChainAsset.setAssetChainId(asset.getChainId());
                    toChainAsset.setAssetId(asset.getAssetId());
                    toChainAsset.setInNumber(toAssetMap.get(toAssetKey));
                    batchUpdateChainAsset.put(key, toChainAsset);
                } else {
                    BigInteger inAsset = toChainAsset.getInNumber();
                    BigInteger tempAmount = toAssetMap.get(toAssetKey) == null ? BigInteger.ZERO : toAssetMap.get(toAssetKey);
                    BigInteger inNumberBigInt = tempAmount.add(inAsset);
                    toChainAsset.setInNumber(inNumberBigInt);
                }
                batchUpdateChainAsset.put(key, toChainAsset);
            }
        }
        if (batchUpdateChainAsset.size() > 0) {
            this.assetService.batchSaveOrUpdateChainAsset(batchUpdateChainAsset);
        }
        if (batchUpdateAsset.size() > 0) {
            this.assetService.batchUpdateAsset(batchUpdateAsset);
        }
        if (batchUpdateBlockChain.size() > 0) {
            this.chainService.batchUpdateChain(batchUpdateBlockChain);
        }
        return ChainEventResult.getResultSuccess();
    }
}

