/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.tx.v5;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.ChainEventResult;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.rpc.call.RpcService;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.CacheDataService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.service.CmTransferService;
import io.nuls.chain.service.ValidateService;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.chain.util.TxUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="AddAssetTxProcessorV5")
public class AddAssetTransferProcessor
implements TransactionProcessor {
    @Autowired
    private ValidateService validateService;
    @Autowired
    private CacheDataService cacheDataService;
    @Autowired
    private AssetService assetService;
    @Autowired
    private ChainService chainService;
    @Autowired
    private RpcService rpcService;
    @Autowired
    CmTransferService cmTransferService;

    public int getType() {
        return 13;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ArrayList<Transaction> errorList = new ArrayList<Transaction>();
        HashMap<String, Object> rtData = new HashMap<String, Object>(2);
        rtData.put("errorCode", "");
        rtData.put("txList", errorList);
        try {
            HashMap<String, Integer> assetMap = new HashMap<String, Integer>();
            Asset asset = null;
            ChainEventResult chainEventResult = ChainEventResult.getResultSuccess();
            for (Transaction tx : txs) {
                String txHash = tx.getHash().toHex();
                asset = TxUtil.buildAssetWithTxAssetV5(tx);
                String assetKey = CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId());
                chainEventResult = this.validateService.batchAssetRegValidatorV3(asset, assetMap);
                if (chainEventResult.isSuccess()) {
                    assetMap.put(assetKey, 1);
                    LoggerUtil.logger().debug("txHash = {},assetKey={} reg batchValidate success!", new Object[]{txHash, assetKey});
                    continue;
                }
                rtData.put("errorCode", chainEventResult.getErrorCode().getCode());
                LoggerUtil.logger().error("txHash = {},assetKey={} reg batchValidate fail!", new Object[]{txHash, assetKey});
                errorList.add(tx);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            throw new RuntimeException(e);
        }
        return rtData;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        long commitHeight = blockHeader.getHeight();
        ArrayList<Asset> assets = new ArrayList<Asset>();
        Asset asset = null;
        try {
            for (Transaction tx : txs) {
                asset = TxUtil.buildAssetWithTxAssetV5(tx);
                this.assetService.registerAsset(asset);
                assets.add(asset);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            try {
                this.cacheDataService.rollBlockTxs(chainId, commitHeight);
            }
            catch (Exception e1) {
                LoggerUtil.logger().error(e);
                throw new RuntimeException(e);
            }
            return false;
        }
        this.rpcService.registerCrossAsset(assets, blockHeader.getTime());
        return true;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            return this.cmTransferService.rollbackV3(chainId, txs, blockHeader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

