/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.tx.v7;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.chain.model.dto.ChainEventResult;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.rpc.call.RpcService;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.CacheDataService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.service.CmTransferService;
import io.nuls.chain.service.ValidateService;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.chain.util.TxUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="DestroyChainTxProcessorV7")
public class DestroyChainTransferProcessor
implements TransactionProcessor {
    @Autowired
    private ValidateService validateService;
    @Autowired
    private CacheDataService cacheDataService;
    @Autowired
    private AssetService assetService;
    @Autowired
    private ChainService chainService;
    @Autowired
    private RpcService rpcService;
    @Autowired
    CmTransferService cmTransferService;

    public int getType() {
        return 12;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ArrayList<Transaction> errorList = new ArrayList<Transaction>();
        HashMap<String, Object> rtData = new HashMap<String, Object>(2);
        rtData.put("errorCode", "");
        rtData.put("txList", errorList);
        try {
            HashMap chainMap = new HashMap();
            HashMap assetMap = new HashMap();
            BlockChain blockChain = null;
            Object asset = null;
            ChainEventResult chainEventResult = ChainEventResult.getResultSuccess();
            for (Transaction tx : txs) {
                String txHash = tx.getHash().toHex();
                blockChain = TxUtil.buildChainWithTxDataV4(tx, true);
                chainEventResult = this.validateService.chainDisableValidator(blockChain);
                if (chainEventResult.isSuccess()) {
                    LoggerUtil.logger().debug("txHash = {},chainId={} destroy batchValidate success!", new Object[]{txHash, blockChain.getChainId()});
                    continue;
                }
                rtData.put("errorCode", chainEventResult.getErrorCode().getCode());
                LoggerUtil.logger().error("txHash = {},chainId={} destroy batchValidate fail!", new Object[]{txHash, blockChain.getChainId()});
                errorList.add(tx);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            throw new RuntimeException(e);
        }
        return rtData;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        long commitHeight = blockHeader.getHeight();
        BlockChain blockChain = null;
        ArrayList<Map<String, Object>> chainAssetIds = new ArrayList<Map<String, Object>>();
        try {
            for (Transaction tx : txs) {
                blockChain = TxUtil.buildChainWithTxDataV4(tx, true);
                this.chainService.destroyBlockChain(blockChain);
                HashMap<String, Integer> chainAssetId = new HashMap<String, Integer>(2);
                chainAssetId.put("chainId", blockChain.getChainId());
                chainAssetId.put("assetId", 0);
                chainAssetIds.add(chainAssetId);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            try {
                this.chainService.rpcBlockChainRollback(txs, blockHeader.getTime());
                this.cacheDataService.rollBlockTxs(chainId, commitHeight);
            }
            catch (Exception e1) {
                LoggerUtil.logger().error(e);
                throw new RuntimeException(e);
            }
            return false;
        }
        this.rpcService.cancelCrossChain(chainAssetIds, blockHeader.getTime());
        return true;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            return this.cmTransferService.rollbackV3(chainId, txs, blockHeader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

