/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.bo.round;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Address;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.DoubleUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@ApiModel(name="Round information")
public class MeetingRound {
    @ApiModelProperty(description="Total weight of the current round")
    private double totalWeight;
    @ApiModelProperty(description="Round index")
    private long index;
    @ApiModelProperty(description="Start time of round")
    private long startTime;
    @ApiModelProperty(description="End time of round")
    private long endTime;
    @ApiModelProperty(description="The number of block nodes in this round")
    private int memberCount;
    @ApiModelProperty(description="Member information for this round of block production", type=@TypeDescriptor(value=List.class, collectionElement=MeetingMember.class))
    private List<MeetingMember> memberList;
    @ApiModelProperty(description="Previous round information")
    private MeetingRound preRound;
    @ApiModelProperty(description="Current node block information")
    private MeetingMember myMember;
    private List<MeetingMember> myMemberList = new ArrayList<MeetingMember>();

    public MeetingRound getPreRound() {
        return this.preRound;
    }

    public void setPreRound(MeetingRound preRound) {
        this.preRound = preRound;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void init(List<MeetingMember> memberList, Chain chain) {
        assert (this.startTime > 0L);
        this.memberList = memberList;
        if (null == memberList || memberList.isEmpty()) {
            throw new NulsRuntimeException(ConsensusErrorCode.DATA_ERROR);
        }
        Collections.sort(memberList);
        this.memberCount = memberList.size();
        this.totalWeight = 0.0;
        for (int i = 0; i < this.memberCount; ++i) {
            MeetingMember member = memberList.get(i);
            member.setRoundStartTime(this.getStartTime());
            member.setPackingIndexOfRound(i + 1);
            member.setPackStartTime(this.startTime + (long)i * chain.getConfig().getPackingInterval());
            member.setPackEndTime(member.getPackStartTime() + chain.getConfig().getPackingInterval());
            BigInteger ownTotalWeight = BigInteger.ZERO;
            if (!member.getAgent().getTotalDeposit().equals(BigInteger.ZERO)) {
                ownTotalWeight = member.getAgent().getTotalDeposit().add(member.getAgent().getDeposit());
            }
            this.totalWeight += DoubleUtils.mul((double)member.getAgent().getCreditVal(), (BigDecimal)new BigDecimal(ownTotalWeight));
        }
        this.endTime = this.startTime + (long)this.memberCount * chain.getConfig().getPackingInterval();
    }

    public MeetingMember getMember(int order) {
        if (order == 0) {
            throw new NulsRuntimeException(ConsensusErrorCode.DATA_ERROR);
        }
        if (null == this.memberList || this.memberList.isEmpty()) {
            throw new NulsRuntimeException(ConsensusErrorCode.DATA_ERROR);
        }
        return this.memberList.get(order - 1);
    }

    public MeetingMember getOnlyMember(byte[] address, Chain chain) {
        for (MeetingMember member : this.memberList) {
            if (!Arrays.equals(address, member.getAgent().getPackingAddress())) continue;
            return member;
        }
        return null;
    }

    public MeetingMember getMember(byte[] address, Chain chain) {
        for (MeetingMember member : this.memberList) {
            if (!Arrays.equals(address, member.getAgent().getPackingAddress()) || !this.validAccount(chain, AddressTool.getStringAddressByBytes((byte[])member.getAgent().getPackingAddress()))) continue;
            return member;
        }
        return null;
    }

    private boolean validAccount(Chain chain, String address) {
        try {
            HashMap callResult = CallMethodUtils.accountValid(chain.getConfig().getChainId(), address, chain.getConfig().getPassword());
            String priKey = (String)callResult.get("priKey");
            if (StringUtils.isNotBlank((String)priKey)) {
                return true;
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
        return false;
    }

    public MeetingMember getMemberByAgentAddress(byte[] address) {
        for (MeetingMember member : this.memberList) {
            if (!Arrays.equals(address, member.getAgent().getAgentAddress())) continue;
            return member;
        }
        return null;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public List<MeetingMember> getMemberList() {
        return this.memberList;
    }

    public MeetingMember getMyMember() {
        return this.myMember;
    }

    public List<MeetingMember> getLocalMembers() {
        return this.myMemberList;
    }

    public void calcLocalPacker(List<byte[]> localAddressList, Chain chain) {
        for (byte[] address : localAddressList) {
            MeetingMember member = this.getMember(address, chain);
            if (null == member) continue;
            this.myMember = member;
            this.myMemberList.add(member);
        }
        if (this.myMember != null && !chain.isPacker()) {
            CallMethodUtils.sendState(chain, true);
            chain.setPacker(true);
        }
        if (this.myMember == null && chain.isPacker()) {
            CallMethodUtils.sendState(chain, false);
            chain.setPacker(false);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (MeetingMember member : this.getMemberList()) {
            str.append(Address.fromHashs((byte[])member.getAgent().getPackingAddress()).getBase58());
            str.append(" ,order:" + member.getPackingIndexOfRound());
            str.append(",packTime:" + new Date(member.getPackEndTime() * 1000L));
            str.append(",creditVal:" + member.getAgent().getRealCreditVal());
            str.append("\n");
        }
        if (null == this.getPreRound()) {
            return "round:index:" + this.getIndex() + " , start:" + new Date(this.getStartTime() * 1000L) + ", netTime:(" + new Date(NulsDateUtils.getCurrentTimeMillis()).toString() + ") , totalWeight : " + this.totalWeight + " ,members:\n" + str;
        }
        return "round:index:" + this.getIndex() + " ,preIndex:" + this.getPreRound().getIndex() + " , start:" + new Date(this.getStartTime()) + ", netTime:(" + new Date(NulsDateUtils.getCurrentTimeMillis()).toString() + ") , totalWeight : " + this.totalWeight + "  , members:\n" + str;
    }
}

