/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.bo.tx.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

@ApiModel(name="Node information")
public class Agent
extends BaseNulsData {
    @ApiModelProperty(description="Node address")
    private byte[] agentAddress;
    @ApiModelProperty(description="Block address")
    private byte[] packingAddress;
    @ApiModelProperty(description="Reward Address")
    private byte[] rewardAddress;
    @ApiModelProperty(description="Margin")
    private BigInteger deposit;
    @ApiModelProperty(description="commission rate")
    private byte commissionRate;
    @ApiModelProperty(description="Creation time")
    private transient long time;
    @ApiModelProperty(description="Block height")
    private transient long blockHeight = -1L;
    @ApiModelProperty(description="Node deregistration height")
    private transient long delHeight = -1L;
    @ApiModelProperty(description="Status,0:Pending consensus unConsensus, 1:In consensus consensus")
    private transient int status;
    @ApiModelProperty(description="Reputation value")
    private transient double creditVal;
    @ApiModelProperty(description="Total entrusted amount of nodes")
    private transient BigInteger totalDeposit = BigInteger.ZERO;
    private transient BigInteger reTotalDeposit = BigInteger.ZERO;
    @ApiModelProperty(description="Create transactions for this nodeHASH")
    private transient NulsHash txHash;
    @ApiModelProperty(description="Number of participants in consensus")
    private transient int memberCount;
    @ApiModelProperty(description="net aliases")
    private transient String alais;

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfBigInteger();
        size += this.agentAddress.length;
        size += this.rewardAddress.length;
        size += this.packingAddress.length;
        return ++size;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBigInteger(this.deposit);
        stream.write(this.agentAddress);
        stream.write(this.packingAddress);
        stream.write(this.rewardAddress);
        stream.write((int)this.commissionRate);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.deposit = byteBuffer.readBigInteger();
        this.agentAddress = byteBuffer.readBytes(23);
        this.packingAddress = byteBuffer.readBytes(23);
        this.rewardAddress = byteBuffer.readBytes(23);
        this.commissionRate = byteBuffer.readByte();
    }

    public byte[] getPackingAddress() {
        return this.packingAddress;
    }

    public void setPackingAddress(byte[] packingAddress) {
        this.packingAddress = packingAddress;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte getCommissionRate() {
        return this.commissionRate;
    }

    public void setCommissionRate(byte commissionRate) {
        this.commissionRate = commissionRate;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public void setCreditVal(double creditVal) {
        this.creditVal = creditVal;
    }

    public double getCreditVal() {
        return this.creditVal < 0.0 ? 0.0 : this.creditVal;
    }

    public double getRealCreditVal() {
        return this.creditVal;
    }

    public void setTxHash(NulsHash txHash) {
        this.txHash = txHash;
    }

    public NulsHash getTxHash() {
        return this.txHash;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getDelHeight() {
        return this.delHeight;
    }

    public void setDelHeight(long delHeight) {
        this.delHeight = delHeight;
    }

    public byte[] getAgentAddress() {
        return this.agentAddress;
    }

    public void setAgentAddress(byte[] agentAddress) {
        this.agentAddress = agentAddress;
    }

    public byte[] getRewardAddress() {
        return this.rewardAddress;
    }

    public void setRewardAddress(byte[] rewardAddress) {
        this.rewardAddress = rewardAddress;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public BigInteger getReTotalDeposit() {
        return this.reTotalDeposit;
    }

    public void setReTotalDeposit(BigInteger reTotalDeposit) {
        this.reTotalDeposit = reTotalDeposit;
    }

    public BigInteger getAvailableDepositAmount(Chain chain) {
        BigInteger commissionMax = chain.getConfig().getCommissionMax();
        if (ProtocolGroupManager.getCurrentVersion((int)chain.getConfig().getChainId()) >= 23) {
            commissionMax = chain.getConfig().getCommissionMaxV23();
        }
        return commissionMax.subtract(this.getTotalDeposit());
    }

    public boolean canDeposit(Chain chain) {
        int flag = this.getAvailableDepositAmount(chain).compareTo(chain.getConfig().getCommissionMin());
        return flag >= 1;
    }

    public BigInteger getDeposit() {
        return this.deposit;
    }

    public void setDeposit(BigInteger deposit) {
        this.deposit = deposit;
    }

    public BigInteger getTotalDeposit() {
        return this.totalDeposit;
    }

    public void setTotalDeposit(BigInteger totalDeposit) {
        this.totalDeposit = totalDeposit;
    }

    public Agent clone() throws CloneNotSupportedException {
        return (Agent)((Object)super.clone());
    }

    public Set<byte[]> getAddresses() {
        HashSet<byte[]> addressSet = new HashSet<byte[]>();
        addressSet.add(this.agentAddress);
        return addressSet;
    }

    public String getAlais() {
        return this.alais;
    }

    public void setAlais(String alais) {
        this.alais = alais;
    }
}

