/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.bo.tx.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

@ApiModel(name="Entrustment information")
public class Deposit
extends BaseNulsData {
    @ApiModelProperty(description="Entrusted amount")
    private BigInteger deposit;
    @ApiModelProperty(description="Delegated nodesHASH")
    private NulsHash agentHash;
    @ApiModelProperty(description="Entrusted account")
    private byte[] address;
    @ApiModelProperty(description="Entrustment time")
    private transient long time;
    @ApiModelProperty(description="state")
    private transient int status;
    @ApiModelProperty(description="Entrusted transactionHASH")
    private transient NulsHash txHash;
    @ApiModelProperty(description="The height at which the entrusted transaction is packaged")
    private transient long blockHeight = -1L;
    @ApiModelProperty(description="Exit commission height")
    private transient long delHeight = -1L;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBigInteger(this.deposit);
        stream.write(this.address);
        stream.write(this.agentHash.getBytes());
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.deposit = byteBuffer.readBigInteger();
        this.address = byteBuffer.readBytes(23);
        this.agentHash = byteBuffer.readHash();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfBigInteger();
        size += 23;
        return size += 32;
    }

    public BigInteger getDeposit() {
        return this.deposit;
    }

    public void setDeposit(BigInteger deposit) {
        this.deposit = deposit;
    }

    public NulsHash getAgentHash() {
        return this.agentHash;
    }

    public void setAgentHash(NulsHash agentHash) {
        this.agentHash = agentHash;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public NulsHash getTxHash() {
        return this.txHash;
    }

    public void setTxHash(NulsHash txHash) {
        this.txHash = txHash;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public long getDelHeight() {
        return this.delHeight;
    }

    public void setDelHeight(long delHeight) {
        this.delHeight = delHeight;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public Set<byte[]> getAddresses() {
        HashSet<byte[]> addressSet = new HashSet<byte[]>();
        addressSet.add(this.address);
        return addressSet;
    }

    public Deposit clone() throws CloneNotSupportedException {
        return (Deposit)((Object)super.clone());
    }
}

