/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.dto.output;

import io.nuls.base.basic.AddressTool;
import io.nuls.consensus.model.po.PunishLogPo;
import io.nuls.consensus.utils.enumeration.PunishReasonEnum;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.util.Date;

public class PunishLogDTO {
    private byte type;
    private String address;
    private String time;
    private long height;
    private long roundIndex;
    private String reasonCode;

    public PunishLogDTO(PunishLogPo po) {
        this.type = po.getType();
        this.address = AddressTool.getStringAddressByBytes((byte[])po.getAddress());
        this.time = NulsDateUtils.convertDate((Date)new Date(po.getTime()));
        this.height = po.getHeight();
        this.roundIndex = po.getRoundIndex();
        this.reasonCode = PunishReasonEnum.getEnum(po.getReasonCode()).getMessage();
    }

    public byte getType() {
        return this.type;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTime() {
        return this.time;
    }

    public long getHeight() {
        return this.height;
    }

    public long getRoundIndex() {
        return this.roundIndex;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }
}

