/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;

public class AgentPo
extends BaseNulsData {
    private transient NulsHash hash;
    private byte[] agentAddress;
    private byte[] packingAddress;
    private byte[] rewardAddress;
    private BigInteger deposit;
    private byte commissionRate;
    private long time;
    private long blockHeight = -1L;
    private long delHeight = -1L;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.hash.getBytes());
        stream.write(this.agentAddress);
        stream.write(this.packingAddress);
        stream.write(this.rewardAddress);
        stream.writeBigInteger(this.deposit);
        stream.write((int)this.commissionRate);
        stream.writeUint48(this.time);
        stream.writeVarInt(this.blockHeight);
        stream.writeVarInt(this.delHeight);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.hash = byteBuffer.readHash();
        this.agentAddress = byteBuffer.readBytes(23);
        this.packingAddress = byteBuffer.readBytes(23);
        this.rewardAddress = byteBuffer.readBytes(23);
        this.deposit = byteBuffer.readBigInteger();
        this.commissionRate = byteBuffer.readByte();
        this.time = byteBuffer.readUint48();
        this.blockHeight = byteBuffer.readVarInt();
        this.delHeight = byteBuffer.readVarInt();
    }

    public int size() {
        int size = 32;
        size += 69;
        size += SerializeUtils.sizeOfBigInteger();
        ++size;
        size += SerializeUtils.sizeOfUint48();
        size += SerializeUtils.sizeOfVarInt((Long)this.blockHeight);
        return size += SerializeUtils.sizeOfVarInt((Long)this.delHeight);
    }

    public NulsHash getHash() {
        return this.hash;
    }

    public void setHash(NulsHash hash) {
        this.hash = hash;
    }

    public byte[] getAgentAddress() {
        return this.agentAddress;
    }

    public void setAgentAddress(byte[] agentAddress) {
        this.agentAddress = agentAddress;
    }

    public byte[] getPackingAddress() {
        return this.packingAddress;
    }

    public void setPackingAddress(byte[] packingAddress) {
        this.packingAddress = packingAddress;
    }

    public byte[] getRewardAddress() {
        return this.rewardAddress;
    }

    public void setRewardAddress(byte[] rewardAddress) {
        this.rewardAddress = rewardAddress;
    }

    public BigInteger getDeposit() {
        return this.deposit;
    }

    public void setDeposit(BigInteger deposit) {
        this.deposit = deposit;
    }

    public byte getCommissionRate() {
        return this.commissionRate;
    }

    public void setCommissionRate(byte commissionRate) {
        this.commissionRate = commissionRate;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public long getDelHeight() {
        return this.delHeight;
    }

    public void setDelHeight(long delHeight) {
        this.delHeight = delHeight;
    }
}

