/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.BlockSignature;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.dto.CmdRegisterDto;
import io.nuls.consensus.utils.compare.BlockHeaderComparator;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallMethodUtils {
    public static final long MIN_PACK_SURPLUS_TIME = 2000L;
    public static final long TIME_OUT = 1000L;

    public static HashMap accountValid(int chainId, String address, String password) throws NulsException {
        try {
            HashMap<String, Object> callParams = new HashMap<String, Object>(4);
            callParams.put("chainId", chainId);
            callParams.put("address", address);
            callParams.put("password", password);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_getPriKeyByAddress", callParams);
            if (!cmdResp.isSuccess()) {
                throw new NulsException(ConsensusErrorCode.ACCOUNT_VALID_ERROR);
            }
            HashMap callResult = (HashMap)((HashMap)cmdResp.getResponseData()).get("ac_getPriKeyByAddress");
            if (callResult == null || callResult.size() == 0) {
                throw new NulsException(ConsensusErrorCode.ACCOUNT_VALID_ERROR);
            }
            return callResult;
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static String createMultiSignAccount(int chainId, MultiSignTxSignature signTxSignature) throws NulsException {
        try {
            HashMap<String, Serializable> callParams = new HashMap<String, Serializable>(4);
            callParams.put("chainId", Integer.valueOf(chainId));
            callParams.put("minSigns", Byte.valueOf(signTxSignature.getM()));
            ArrayList<String> pubKeys = new ArrayList<String>();
            for (byte[] pubKey : signTxSignature.getPubKeyList()) {
                pubKeys.add(HexUtil.encode((byte[])pubKey));
            }
            callParams.put("pubKeys", pubKeys);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_createMultiSignAccount", callParams);
            if (!cmdResp.isSuccess()) {
                throw new NulsException(ConsensusErrorCode.ACCOUNT_VALID_ERROR);
            }
            HashMap callResult = (HashMap)((HashMap)cmdResp.getResponseData()).get("ac_createMultiSignAccount");
            if (callResult == null || callResult.size() == 0) {
                throw new NulsException(ConsensusErrorCode.ACCOUNT_VALID_ERROR);
            }
            return (String)callResult.get("address");
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NulsException(ConsensusErrorCode.INTERFACE_CALL_FAILED);
        }
    }

    public static MultiSigAccount getMultiSignAccount(int chainId, String address) throws NulsException {
        try {
            HashMap<String, Object> callParams = new HashMap<String, Object>(4);
            callParams.put("chainId", chainId);
            callParams.put("address", address);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_getMultiSignAccount", callParams);
            if (!cmdResp.isSuccess()) {
                throw new NulsException(ConsensusErrorCode.ACCOUNT_VALID_ERROR);
            }
            HashMap callResult = (HashMap)((HashMap)cmdResp.getResponseData()).get("ac_getMultiSignAccount");
            if (callResult == null || callResult.size() == 0) {
                throw new NulsException(ConsensusErrorCode.ACCOUNT_VALID_ERROR);
            }
            MultiSigAccount multiSigAccount = new MultiSigAccount();
            multiSigAccount.parse(RPCUtil.decode((String)((String)callResult.get("value"))), 0);
            return multiSigAccount;
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NulsException(ConsensusErrorCode.INTERFACE_CALL_FAILED);
        }
    }

    public static void transactionSignature(int chainId, String address, String password, String priKey, Transaction tx) throws NulsException {
        try {
            P2PHKSignature p2PHKSignature = new P2PHKSignature();
            if (!StringUtils.isBlank((String)priKey)) {
                p2PHKSignature = SignatureUtil.createSignatureByPriKey((Transaction)tx, (String)priKey);
            } else {
                HashMap<String, Object> callParams = new HashMap<String, Object>(4);
                callParams.put("chainId", chainId);
                callParams.put("address", address);
                callParams.put("password", password);
                callParams.put("data", RPCUtil.encode((byte[])tx.getHash().getBytes()));
                Response signResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_signDigest", callParams);
                if (!signResp.isSuccess()) {
                    throw new NulsException(ConsensusErrorCode.TX_SIGNTURE_ERROR);
                }
                HashMap signResult = (HashMap)((HashMap)signResp.getResponseData()).get("ac_signDigest");
                p2PHKSignature.parse(RPCUtil.decode((String)((String)signResult.get("signature"))), 0);
            }
            TransactionSignature signature = new TransactionSignature();
            ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
            p2PHKSignatures.add(p2PHKSignature);
            signature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(signature.serialize());
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static void blockSignature(Chain chain, String address, BlockHeader header) throws NulsException {
        try {
            HashMap<String, Object> callParams = new HashMap<String, Object>(4);
            callParams.put("chainId", chain.getConfig().getChainId());
            callParams.put("address", address);
            callParams.put("password", chain.getConfig().getPassword());
            callParams.put("data", RPCUtil.encode((byte[])header.getHash().getBytes()));
            Response signResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_signBlockDigest", callParams);
            if (!signResp.isSuccess()) {
                throw new NulsException(ConsensusErrorCode.TX_SIGNTURE_ERROR);
            }
            HashMap signResult = (HashMap)((HashMap)signResp.getResponseData()).get("ac_signBlockDigest");
            BlockSignature blockSignature = new BlockSignature();
            blockSignature.parse(RPCUtil.decode((String)((String)signResult.get("signature"))), 0);
            header.setBlockSignature(blockSignature);
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static void receivePackingBlock(int chainId, String block, long timeOut) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("block", block);
        try {
            ResponseMessageProcessor.requestAndResponse((String)ModuleE.BL.abbr, (String)"receivePackingBlock", params, (long)timeOut);
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static int getAvailableNodeAmount(int chainId, boolean isCross) throws NulsException {
        HashMap<String, Constable> callParams = new HashMap<String, Constable>(4);
        callParams.put("chainId", Integer.valueOf(chainId));
        callParams.put("isCross", Boolean.valueOf(isCross));
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_getChainConnectAmount", callParams);
            if (!callResp.isSuccess()) {
                throw new NulsException(ConsensusErrorCode.INTERFACE_CALL_FAILED);
            }
            HashMap callResult = (HashMap)((HashMap)callResp.getResponseData()).get("nw_getChainConnectAmount");
            return (Integer)callResult.get("connectAmount");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static Map<String, Object> getBalanceAndNonce(Chain chain, String address, int assetChainId, int assetId) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("assetChainId", assetChainId);
        params.put("address", address);
        params.put("assetId", assetId);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getBalanceNonce", params);
            if (!callResp.isSuccess()) {
                return null;
            }
            return (HashMap)((HashMap)callResp.getResponseData()).get("getBalanceNonce");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static Map<String, Object> getBalance(Chain chain, String address, int assetChainId, int assetId) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("assetChainId", assetChainId);
        params.put("address", address);
        params.put("assetId", assetId);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getBalance", params);
            if (!callResp.isSuccess()) {
                return null;
            }
            return (HashMap)((HashMap)callResp.getResponseData()).get("getBalance");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static Map<String, Object> getPackingTxList(Chain chain, long blockTime, String packingAddress) {
        try {
            long realTime = blockTime * 1000L;
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chain.getConfig().getChainId());
            long currentTime = NulsDateUtils.getCurrentTimeMillis();
            long surplusTime = realTime - currentTime;
            if (surplusTime <= 2000L) {
                return null;
            }
            params.put("endTimestamp", realTime - 1000L);
            params.put("maxTxDataSize", chain.getConfig().getBlockMaxSize());
            params.put("blockTime", blockTime);
            params.put("packingAddress", packingAddress);
            BlockExtendsData preExtendsData = chain.getNewestHeader().getExtendsData();
            byte[] preStateRoot = preExtendsData.getStateRoot();
            params.put("preStateRoot", RPCUtil.encode((byte[])preStateRoot));
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_packableTxs", params, (long)(surplusTime - 1000L));
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Packaging transaction acquisition failure!");
                return null;
            }
            return (HashMap)((HashMap)cmdResp.getResponseData()).get("tx_packableTxs");
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return null;
        }
    }

    public static Transaction getTransaction(Chain chain, String txHash) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chain.getConfig().getChainId());
            params.put("txHash", txHash);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_getConfirmedTx", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Acquisition transaction failed\uff01");
                return null;
            }
            Map responseData = (Map)cmdResp.getResponseData();
            Map realData = (Map)responseData.get("tx_getConfirmedTx");
            if (realData.get("tx") == null) {
                return null;
            }
            String txHex = (String)realData.get("tx");
            Transaction tx = new Transaction();
            if (StringUtils.isBlank((String)txHex)) {
                return null;
            }
            tx.parse(RPCUtil.decode((String)txHex), 0);
            return tx;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return null;
        }
    }

    public static void sendTx(Chain chain, String tx) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("tx", tx);
        try {
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_newTx", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Transaction failed to send!");
                throw new NulsException(ConsensusErrorCode.FAILED);
            }
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
    }

    public static void sendState(Chain chain, boolean packing) {
        try {
            HashMap<String, Constable> params = new HashMap<String, Constable>(4);
            params.put("chainId", Integer.valueOf(chain.getConfig().getChainId()));
            params.put("packaging", Boolean.valueOf(packing));
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_cs_state", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Packing state failed to send!");
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
    }

    public static Response verify(int chainId, List<Transaction> transactions, BlockHeader header, BlockHeader lastHeader, NulsLogger logger) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("chainId", chainId);
            ArrayList<String> txList = new ArrayList<String>();
            for (Transaction transaction : transactions) {
                txList.add(RPCUtil.encode((byte[])transaction.serialize()));
            }
            params.put("txList", txList);
            BlockExtendsData lastData = lastHeader.getExtendsData();
            params.put("preStateRoot", RPCUtil.encode((byte[])lastData.getStateRoot()));
            params.put("blockHeader", RPCUtil.encode((byte[])header.serialize()));
            return ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_batchVerify", params, (long)600000L);
        }
        catch (Exception e) {
            logger.error("", e);
            return null;
        }
    }

    public static String getNonce(String txHash) {
        return txHash.substring(txHash.length() - 8);
    }

    public static byte[] getNonce(byte[] txHash) {
        byte[] targetArr = new byte[8];
        System.arraycopy(txHash, txHash.length - 8, targetArr, 0, 8);
        return targetArr;
    }

    public static List<byte[]> getEncryptedAddressList(Chain chain) {
        ArrayList<byte[]> packingAddressList = new ArrayList<byte[]>();
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(2);
            params.put("chainId", chain.getConfig().getChainId());
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_getEncryptedAddressList", params);
            List accountAddressList = (List)((HashMap)((HashMap)cmdResp.getResponseData()).get("ac_getEncryptedAddressList")).get("list");
            if (accountAddressList != null && accountAddressList.size() > 0) {
                for (String address : accountAddressList) {
                    packingAddressList.add(AddressTool.getAddress((String)address));
                }
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
        return packingAddressList;
    }

    public static String getAlias(Chain chain, String address) {
        String alias = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("version", "1.0");
            params.put("chainId", chain.getConfig().getChainId());
            params.put("address", address);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_getAliasByAddress", params);
            HashMap result = (HashMap)((HashMap)cmdResp.getResponseData()).get("ac_getAliasByAddress");
            String paramAlias = "alias";
            if (result.get(paramAlias) != null) {
                alias = (String)result.get("alias");
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
        return alias;
    }

    public static void loadBlockHeader(Chain chain) throws Exception {
        Map result;
        Map responseData;
        HashMap<String, Integer> params = new HashMap<String, Integer>(16);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("round", 110);
        Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.BL.abbr, (String)"getLatestRoundBlockHeaders", params);
        List blockHeaderHexs = new ArrayList();
        if (response.isSuccess()) {
            responseData = (Map)response.getResponseData();
            result = (Map)responseData.get("getLatestRoundBlockHeaders");
            blockHeaderHexs = (List)result.get("value");
        }
        while (!response.isSuccess() && blockHeaderHexs.size() == 0) {
            response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.BL.abbr, (String)"getLatestRoundBlockHeaders", params);
            if (response.isSuccess()) {
                responseData = (Map)response.getResponseData();
                result = (Map)responseData.get("getLatestRoundBlockHeaders");
                blockHeaderHexs = (List)result.get("value");
                break;
            }
            Log.debug((String)"---------------------------Block loading failed\uff01");
            Thread.sleep(1000L);
        }
        ArrayList<BlockHeader> blockHeaders = new ArrayList<BlockHeader>();
        for (String blockHeaderHex : blockHeaderHexs) {
            BlockHeader blockHeader = new BlockHeader();
            blockHeader.parse(RPCUtil.decode((String)blockHeaderHex), 0);
            blockHeaders.add(blockHeader);
        }
        blockHeaders.sort(new BlockHeaderComparator());
        chain.setBlockHeaderList(blockHeaders);
        chain.setNewestHeader((BlockHeader)blockHeaders.get(blockHeaders.size() - 1));
        Log.debug((String)"---------------------------Block loading successful\uff01");
    }

    public static void getRoundBlockHeaders(Chain chain, long roundCount, long startHeight) throws Exception {
        Map responseData;
        HashMap<String, Number> params = new HashMap<String, Number>(16);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("round", roundCount);
        params.put("height", startHeight);
        Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.BL.abbr, (String)"getRoundBlockHeaders", params);
        List blockHeaderHexs = new ArrayList();
        if (response.isSuccess()) {
            responseData = (Map)response.getResponseData();
            Map result = (Map)responseData.get("getRoundBlockHeaders");
            blockHeaderHexs = (List)result.get("value");
        }
        for (int tryCount = 0; !response.isSuccess() && blockHeaderHexs.size() == 0 && tryCount < 5; ++tryCount) {
            response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.BL.abbr, (String)"getRoundBlockHeaders", params);
            if (response.isSuccess()) {
                responseData = (Map)response.getResponseData();
                Map result = (Map)responseData.get("getRoundBlockHeaders");
                blockHeaderHexs = (List)result.get("value");
                break;
            }
            Log.debug((String)"---------------------------Rollback block round change failed to load block from scratch\uff01");
            Thread.sleep(1000L);
        }
        ArrayList<BlockHeader> blockHeaders = new ArrayList<BlockHeader>();
        for (String blockHeaderHex : blockHeaderHexs) {
            BlockHeader blockHeader = new BlockHeader();
            blockHeader.parse(RPCUtil.decode((String)blockHeaderHex), 0);
            blockHeaders.add(blockHeader);
        }
        blockHeaders.sort(new BlockHeaderComparator());
        chain.getBlockHeaderList().addAll(0, blockHeaders);
        Log.debug((String)"---------------------------Rollback block round change successfully reloading block from scratch\uff01");
    }

    public static boolean commitUnconfirmedTx(Chain chain, String tx) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("tx", tx);
        try {
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"commitUnconfirmedTx", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Ledger module verifies transaction failure!");
                return false;
            }
            HashMap result = (HashMap)((HashMap)cmdResp.getResponseData()).get("commitUnconfirmedTx");
            int validateCode = (Integer)result.get("validateCode");
            if (validateCode == 1) {
                return true;
            }
            chain.getLogger().info("Ledger module verifies transaction failure,error info:" + result.get("validateDesc"));
            return false;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    public static boolean rollBackUnconfirmTx(Chain chain, String tx) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("tx", tx);
        try {
            HashMap result;
            int validateCode;
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"rollBackUnconfirmTx", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Ledger module rollBack transaction failure!");
            }
            if ((validateCode = ((Integer)(result = (HashMap)((HashMap)cmdResp.getResponseData()).get("rollBackUnconfirmTx")).get("value")).intValue()) == 1) {
                return true;
            }
            chain.getLogger().info("Ledger module rollBack transaction failure!");
            return false;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    public static boolean transactionBasicValid(Chain chain, String tx) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("tx", tx);
        try {
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_baseValidateTx", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Failure of transaction basic validation!");
                return false;
            }
            HashMap result = (HashMap)((HashMap)cmdResp.getResponseData()).get("tx_baseValidateTx");
            return (Boolean)result.get("value");
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    public static Map getVersion(int chainId) throws NulsException {
        HashMap<String, Integer> params = new HashMap<String, Integer>(4);
        params.put("chainId", chainId);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.PU.abbr, (String)"getVersion", params);
            if (!callResp.isSuccess()) {
                return null;
            }
            return (Map)((Map)callResp.getResponseData()).get("getVersion");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static boolean registerContractTx(int chainId, List<CmdRegisterDto> cmdRegisterDtoList) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("moduleCode", ModuleE.CS.abbr);
        params.put("cmdRegisterList", cmdRegisterDtoList);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.SC.abbr, (String)"sc_register_cmd_for_contract", params);
            return callResp.isSuccess();
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    public static String triggerContract(int chainId, String stateRoot, long height, String contractAddress, String coinBaseTx) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("stateRoot", stateRoot);
        params.put("blockHeight", height);
        params.put("contractAddress", contractAddress);
        params.put("tx", coinBaseTx);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.SC.abbr, (String)"sc_trigger_payable_for_consensus_contract", params);
            if (!callResp.isSuccess()) {
                return null;
            }
            HashMap result = (HashMap)((HashMap)callResp.getResponseData()).get("sc_trigger_payable_for_consensus_contract");
            return (String)result.get("value");
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }
}

