/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.rpc.cmd;

import io.nuls.consensus.service.BlockService;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.CS)
public class BlockCmd
extends BaseCmd {
    @Autowired
    private BlockService service;

    @CmdAnnotation(cmd="cs_addBlock", version=1.0, description="Receive and cache new blocks/Receiving and caching new blocks")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="blockHeader", parameterType="String", parameterDes="Block head")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Whether the interface execution is successful or not")}))
    public Response addBlock(Map<String, Object> params) {
        Result result = this.service.addBlock(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="cs_validBlock", version=1.0, description="Verify Block/verify block correctness")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="download", requestType=@TypeDescriptor(value=int.class), parameterDes="Block status"), @Parameter(parameterName="block", parameterType="String", parameterDes="Block information")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Verification results")}))
    public Response validBlock(Map<String, Object> params) {
        Result result = this.service.validBlock(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="cs_receiveHeaderList", version=1.0, description="Receive and cache block list/Receive and cache block lists")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="headerList", parameterType="List<String>", parameterDes="Block header list")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Successfully received and processed")}))
    public Response receiveHeaderList(Map<String, Object> params) {
        Result result = this.service.receiveHeaderList(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="cs_chainRollBack", version=1.0, description="Block rollback/chain rollback")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=int.class), parameterDes="The height to which the block is rolled back")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Block rollback result")}))
    public Response chainRollBack(Map<String, Object> params) {
        Result result = this.service.chainRollBack(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }
}

