/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.rpc.cmd;

import io.nuls.consensus.service.AgentService;
import io.nuls.consensus.service.DepositService;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.CS)
public class ConsensusTransactionHandler
extends BaseCmd {
    @Autowired
    private AgentService agentService;
    @Autowired
    private DepositService depositService;

    @CmdAnnotation(cmd="stopAgentValid", version=1.0, description="stop agent transaction validate")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterType="String", parameterDes="transaction")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Stop node transaction verification results")}))
    public Response stopAgentValid(Map<String, Object> params) {
        Result result = this.agentService.stopAgentValid(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="createAgentValid", version=1.0, description="create agent transaction validate")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterType="String", parameterDes="transaction")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Create node validation results")}))
    public Response createAgentValid(Map<String, Object> params) {
        Result result = this.agentService.createAgentValid(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="withdrawValid", version=1.0, description="withdraw deposit agent transaction validate")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterType="String", parameterDes="transaction")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Exit consensus transaction verification result")}))
    public Response withdrawValid(Map<String, Object> params) {
        Result result = this.depositService.withdrawValid(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }

    @CmdAnnotation(cmd="depositValid", version=1.0, description="deposit agent transaction validate")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterType="String", parameterDes="transaction")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Verification results of entrusted transactions")}))
    public Response depositValid(Map<String, Object> params) {
        Result result = this.depositService.depositValid(params);
        if (result.isFailed()) {
            return this.failed(result.getErrorCode());
        }
        return this.success(result.getData());
    }
}

