/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.rpc.cmd;

import io.nuls.consensus.model.dto.RandomSeedDTO;
import io.nuls.consensus.storage.RandomSeedsStorageService;
import io.nuls.consensus.utils.RandomSeedCaculator;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.CS)
public class RandomCmd
extends BaseCmd {
    @Autowired
    private RandomSeedsStorageService randomSeedService;

    @CmdAnnotation(cmd="cs_random_seed_count", version=1.0, description="Generate a random seed based on the maximum height and the number of original seeds and return it")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="Maximum height"), @Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="Original number of seeds"), @Parameter(parameterName="algorithm", parameterDes="Algorithm identification\uff1aSHA3, KECCAK, MERKLE")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=RandomSeedDTO.class))
    public Response getRandomSeedByCount(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            Long height = Long.parseLong(params.get("height").toString());
            Integer count = (Integer)params.get("count");
            String algorithm = (String)params.get("algorithm");
            List<byte[]> list = this.randomSeedService.getSeeds((int)chainId, (long)height, count);
            if (list.size() != count.intValue()) {
                return this.failed("not enough raw random seed");
            }
            byte[] seed = RandomSeedCaculator.clac(list, algorithm);
            if (null == seed) {
                return this.failed("empty random seed");
            }
            RandomSeedDTO dto = new RandomSeedDTO();
            dto.setCount(count);
            if (StringUtils.isNotBlank((String)algorithm)) {
                dto.setAlgorithm(algorithm.toUpperCase());
            } else {
                dto.setAlgorithm("SHA3");
            }
            BigInteger value = new BigInteger(seed);
            dto.setSeed(value.toString());
            return this.success(dto);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="cs_random_seed_height", version=1.0, description="Generate a random seed based on the height interval and return it")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="startHeight", requestType=@TypeDescriptor(value=long.class), parameterDes="Starting height"), @Parameter(parameterName="endHeight", requestType=@TypeDescriptor(value=long.class), parameterDes="Cut-off height"), @Parameter(parameterName="algorithm", parameterDes="Algorithm identification\uff1aSHA3, KECCAK, MERKLE")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=RandomSeedDTO.class))
    public Response getRandomSeedByHeight(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            Long startHeight = Long.parseLong(params.get("startHeight").toString());
            Long endHeight = Long.parseLong(params.get("endHeight").toString());
            String algorithm = (String)params.get("algorithm");
            List<byte[]> list = this.randomSeedService.getSeeds((int)chainId, (long)startHeight, endHeight);
            int count = list.size();
            if (list.isEmpty()) {
                return this.failed("empty random seed");
            }
            byte[] seed = RandomSeedCaculator.clac(list, algorithm);
            if (null == seed) {
                return this.failed("empty random seed");
            }
            RandomSeedDTO dto = new RandomSeedDTO();
            dto.setCount(count);
            if (StringUtils.isNotBlank((String)algorithm)) {
                dto.setAlgorithm(algorithm.toUpperCase());
            } else {
                dto.setAlgorithm("SHA3");
            }
            BigInteger value = new BigInteger(seed);
            dto.setSeed(value.toString());
            return this.success(dto);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="cs_random_raw_seeds_count", version=1.0, description="Search for the original seed list based on height and return")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="Maximum height"), @Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="Original number of seeds")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public Response getRandomRawSeedsByCount(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            Long height = Long.parseLong(params.get("height").toString());
            Integer count = (Integer)params.get("count");
            List<byte[]> list = this.randomSeedService.getSeeds((int)chainId, (long)height, count);
            if (list.size() != count.intValue()) {
                return this.failed("not enough raw random seed");
            }
            ArrayList<String> seeds = new ArrayList<String>();
            for (byte[] value : list) {
                seeds.add(new BigInteger(value).toString());
            }
            return this.success(seeds);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="cs_random_raw_seeds_height", version=1.0, description="Query the original seed list based on the height interval and return it")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="startHeight", requestType=@TypeDescriptor(value=long.class), parameterDes="Starting height"), @Parameter(parameterName="endHeight", requestType=@TypeDescriptor(value=long.class), parameterDes="Cut-off height")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public Response getRandomRawSeedsByHeight(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            Long startHeight = Long.parseLong(params.get("startHeight").toString());
            Long endHeight = Long.parseLong(params.get("endHeight").toString());
            List<byte[]> list = this.randomSeedService.getSeeds((int)chainId, (long)startHeight, endHeight);
            if (list.isEmpty()) {
                return this.failed("empty random seed");
            }
            ArrayList<String> seeds = new ArrayList<String>();
            for (byte[] value : list) {
                seeds.add(new BigInteger(value).toString());
            }
            return this.success(seeds);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return this.failed(e.getMessage());
        }
    }
}

