/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.tx.v1;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.RedPunishData;
import io.nuls.consensus.utils.LoggerUtil;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component(value="CreateAgentProcessorV1")
public class CreateAgentProcessor
implements TransactionProcessor {
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TxValidator txValidator;

    public int getType() {
        return 4;
    }

    public int getPriority() {
        return 8;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        Agent agent;
        List<Transaction> contractCreateAgentTxList;
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            result.put("txList", txs);
            result.put("errorCode", ConsensusErrorCode.CHAIN_NOT_EXIST.getCode());
            return result;
        }
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        String errorCode = null;
        HashSet<String> redPunishAddressSet = new HashSet<String>();
        HashSet<String> createAgentAddressSet = new HashSet<String>();
        List<Transaction> redPunishTxList = txMap.get(8);
        if (redPunishTxList != null && redPunishTxList.size() > 0) {
            for (Transaction redPunishTx : redPunishTxList) {
                RedPunishData redPunishData = new RedPunishData();
                try {
                    redPunishData.parse(redPunishTx.getTxData(), 0);
                    String addressHex = HexUtil.encode((byte[])redPunishData.getAddress());
                    redPunishAddressSet.add(addressHex);
                }
                catch (NulsException e) {
                    chain.getLogger().error(e);
                }
            }
        }
        if ((contractCreateAgentTxList = txMap.get(20)) != null && contractCreateAgentTxList.size() > 0) {
            for (Transaction contractCreateAgentTx : contractCreateAgentTxList) {
                try {
                    agent = new Agent();
                    agent.parse(contractCreateAgentTx.getTxData(), 0);
                    createAgentAddressSet.add(HexUtil.encode((byte[])agent.getAgentAddress()));
                    createAgentAddressSet.add(HexUtil.encode((byte[])agent.getPackingAddress()));
                }
                catch (Exception e) {
                    chain.getLogger().error(e);
                }
            }
        }
        for (Transaction createAgentTx : txs) {
            try {
                if (!this.txValidator.validateTx(chain, createAgentTx)) {
                    invalidTxList.add(createAgentTx);
                    chain.getLogger().info("Failure to create node transaction validation");
                    continue;
                }
                agent = new Agent();
                agent.parse(createAgentTx.getTxData(), 0);
                String agentAddressHex = HexUtil.encode((byte[])agent.getAgentAddress());
                String packAddressHex = HexUtil.encode((byte[])agent.getPackingAddress());
                if (!redPunishAddressSet.isEmpty() && (redPunishAddressSet.contains(agentAddressHex) || redPunishAddressSet.contains(packAddressHex))) {
                    invalidTxList.add(createAgentTx);
                    chain.getLogger().info("Creating Node Trading and Red Card Trading Conflict");
                    errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
                    continue;
                }
                if (createAgentAddressSet.add(agentAddressHex) && createAgentAddressSet.add(packAddressHex)) continue;
                invalidTxList.add(createAgentTx);
                chain.getLogger().info("Repeated transactions");
                errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
            }
            catch (NulsException e) {
                invalidTxList.add(createAgentTx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
            }
            catch (IOException io) {
                invalidTxList.add(createAgentTx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error((Exception)io);
                errorCode = ConsensusErrorCode.SERIALIZE_ERROR.getCode();
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        boolean commitResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.agentManager.createAgentCommit(tx, blockHeader, chain)) continue;
                commitSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to create agent transaction submission");
                chain.getLogger().error(e);
                commitResult = false;
            }
        }
        if (!commitResult) {
            for (Transaction rollbackTx : commitSuccessList) {
                try {
                    this.agentManager.createAgentRollBack(rollbackTx, chain);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to create agent transaction rollback");
                    chain.getLogger().error(e);
                }
            }
        }
        return commitResult;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> rollbackSuccessList = new ArrayList<Transaction>();
        boolean rollbackResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.agentManager.createAgentRollBack(tx, chain)) continue;
                rollbackSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to create node transaction rollback");
                chain.getLogger().error(e);
                rollbackResult = false;
            }
        }
        if (!rollbackResult) {
            for (Transaction commitTx : rollbackSuccessList) {
                try {
                    this.agentManager.createAgentCommit(commitTx, blockHeader, chain);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to create node transaction submission");
                    chain.getLogger().error(e);
                }
            }
        }
        return rollbackResult;
    }
}

