/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.consensus.utils.compare.AgentComparator;
import io.nuls.consensus.utils.manager.DepositManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@Component
public class AgentManager {
    @Autowired
    private AgentStorageService agentStorageService;
    @Autowired
    private DepositStorageService depositStorageService;
    @Autowired
    private DepositManager depositManager;
    @Autowired
    private RoundManager roundManager;

    public void loadAgents(Chain chain) throws Exception {
        ArrayList<Agent> allAgentList = new ArrayList<Agent>();
        List<AgentPo> poList = this.agentStorageService.getList(chain.getConfig().getChainId());
        for (AgentPo po : poList) {
            Agent agent = this.poToAgent(po);
            allAgentList.add(agent);
        }
        Collections.sort(allAgentList, new AgentComparator());
        chain.setAgentList(allAgentList);
    }

    public void addAgent(Chain chain, Agent agent) {
        chain.getAgentList().add(agent);
    }

    public void updateAgent(Chain chain, Agent agent) {
        List<Agent> agentList = chain.getAgentList();
        if (agentList == null || agentList.size() == 0) {
            agentList = new ArrayList<Agent>();
            agentList.add(agent);
            return;
        }
        for (int index = 0; index < agentList.size(); ++index) {
            if (!agent.getTxHash().equals((Object)agentList.get(index).getTxHash())) continue;
            agentList.set(index, agent);
            return;
        }
    }

    public void removeAgent(Chain chain, NulsHash txHash) {
        List<Agent> agentList = chain.getAgentList();
        if (agentList == null || agentList.size() == 0) {
            return;
        }
        for (Agent agent : agentList) {
            if (!txHash.equals((Object)agent.getTxHash())) continue;
            agentList.remove((Object)agent);
            return;
        }
    }

    public Agent getAgentByAgentAddress(Chain chain, byte[] agentAddress) {
        for (Agent agent : chain.getAgentList()) {
            if (agent.getDelHeight() > 0L || !Arrays.equals(agentAddress, agent.getAgentAddress())) continue;
            return agent;
        }
        return null;
    }

    public Agent poToAgent(AgentPo agentPo) {
        if (agentPo == null) {
            return null;
        }
        Agent agent = new Agent();
        agent.setAgentAddress(agentPo.getAgentAddress());
        agent.setBlockHeight(agentPo.getBlockHeight());
        agent.setCommissionRate(agentPo.getCommissionRate());
        agent.setDeposit(agentPo.getDeposit());
        agent.setPackingAddress(agentPo.getPackingAddress());
        agent.setRewardAddress(agentPo.getRewardAddress());
        agent.setTxHash(agentPo.getHash());
        agent.setTime(agentPo.getTime());
        agent.setDelHeight(agentPo.getDelHeight());
        return agent;
    }

    public AgentPo agentToPo(Agent agent) {
        if (agent == null) {
            return null;
        }
        AgentPo agentPo = new AgentPo();
        agentPo.setAgentAddress(agent.getAgentAddress());
        agentPo.setBlockHeight(agent.getBlockHeight());
        agentPo.setCommissionRate(agent.getCommissionRate());
        agentPo.setDeposit(agent.getDeposit());
        agentPo.setPackingAddress(agent.getPackingAddress());
        agentPo.setRewardAddress(agent.getRewardAddress());
        agentPo.setHash(agent.getTxHash());
        agentPo.setTime(agent.getTime());
        return agentPo;
    }

    public String getAgentId(NulsHash hash) {
        String hashHex = hash.toHex();
        return hashHex.substring(hashHex.length() - 8).toUpperCase();
    }

    public boolean createAgentCommit(Transaction transaction, BlockHeader blockHeader, Chain chain) throws NulsException {
        Agent agent = new Agent();
        agent.parse(transaction.getTxData(), 0);
        agent.setTxHash(transaction.getHash());
        agent.setBlockHeight(blockHeader.getHeight());
        agent.setTime(transaction.getTime());
        AgentPo agentPo = this.agentToPo(agent);
        if (!this.agentStorageService.save(agentPo, chain.getConfig().getChainId())) {
            throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
        }
        this.addAgent(chain, agent);
        return true;
    }

    public boolean createAgentRollBack(Transaction transaction, Chain chain) throws NulsException {
        if (!this.agentStorageService.delete(transaction.getHash(), chain.getConfig().getChainId())) {
            throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
        }
        this.removeAgent(chain, transaction.getHash());
        return true;
    }

    public boolean stopAgentCommit(Transaction transaction, BlockHeader blockHeader, Chain chain) throws NulsException {
        int chainId = chain.getConfig().getChainId();
        StopAgent stopAgent = new StopAgent();
        stopAgent.parse(transaction.getTxData(), 0);
        AgentPo agentPo = this.agentStorageService.get(stopAgent.getCreateTxHash(), chain.getConfig().getChainId());
        if (agentPo == null || agentPo.getDelHeight() > 0L) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        List<DepositPo> depositPoList = this.depositStorageService.getList(chainId);
        for (DepositPo depositPo : depositPoList) {
            if (depositPo.getDelHeight() > -1L || !depositPo.getAgentHash().equals((Object)agentPo.getHash())) continue;
            depositPo.setDelHeight(blockHeader.getHeight());
            if (!this.depositStorageService.save(depositPo, chainId)) {
                throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
            }
            this.depositManager.updateDeposit(chain, this.depositManager.poToDeposit(depositPo));
        }
        agentPo.setDelHeight(blockHeader.getHeight());
        if (!this.agentStorageService.save(agentPo, chainId)) {
            throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
        }
        this.updateAgent(chain, this.poToAgent(agentPo));
        return true;
    }

    public boolean stopAgentRollBack(Transaction transaction, Chain chain, BlockHeader blockHeader) throws NulsException {
        int chainId = chain.getConfig().getChainId();
        StopAgent stopAgent = new StopAgent();
        stopAgent.parse(transaction.getTxData(), 0);
        AgentPo agentPo = this.agentStorageService.get(stopAgent.getCreateTxHash(), chainId);
        agentPo.setDelHeight(-1L);
        List<DepositPo> depositPoList = this.depositStorageService.getList(chainId);
        for (DepositPo depositPo : depositPoList) {
            if (depositPo.getDelHeight() != blockHeader.getHeight() || !depositPo.getAgentHash().equals((Object)agentPo.getHash())) continue;
            depositPo.setDelHeight(-1L);
            if (!this.depositStorageService.save(depositPo, chainId)) {
                throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
            }
            this.depositManager.updateDeposit(chain, this.depositManager.poToDeposit(depositPo));
        }
        if (!this.agentStorageService.save(agentPo, chainId)) {
            throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
        }
        this.updateAgent(chain, this.poToAgent(agentPo));
        return true;
    }

    public void fillAgentList(Chain chain, List<Agent> agentList, List<Deposit> depositList) {
        MeetingRound round = this.roundManager.getCurrentRound(chain);
        for (Agent agent : agentList) {
            this.fillAgent(chain, agent, round, depositList);
        }
    }

    public void fillAgent(Chain chain, Agent agent, MeetingRound round, List<Deposit> depositList) {
        if (null == depositList || depositList.isEmpty()) {
            depositList = chain.getDepositList();
        }
        if (depositList == null || depositList.isEmpty()) {
            agent.setMemberCount(0);
            agent.setTotalDeposit(BigInteger.ZERO);
        } else {
            HashSet<String> memberSet = new HashSet<String>();
            BigInteger total = BigInteger.ZERO;
            for (int i = 0; i < depositList.size(); ++i) {
                Deposit deposit = depositList.get(i);
                if (!agent.getTxHash().equals((Object)deposit.getAgentHash()) || deposit.getDelHeight() >= 0L) continue;
                total = total.add(deposit.getDeposit());
                memberSet.add(AddressTool.getStringAddressByBytes((byte[])deposit.getAddress()));
            }
            agent.setMemberCount(memberSet.size());
            agent.setReTotalDeposit(total);
        }
        if (round == null) {
            return;
        }
        MeetingMember member = round.getOnlyMember(agent.getPackingAddress(), chain);
        if (null == member) {
            agent.setStatus(0);
            return;
        }
        agent.setStatus(1);
        agent.setCreditVal(member.getAgent().getRealCreditVal());
    }

    public BigInteger getAgentDeposit(Chain chain, Agent agent) {
        BigInteger totalDeposit = BigInteger.ZERO;
        for (Deposit deposit : chain.getDepositList()) {
            if (!agent.getTxHash().equals((Object)deposit.getAgentHash()) || deposit.getDelHeight() >= 0L) continue;
            totalDeposit = totalDeposit.add(deposit.getDeposit());
        }
        return totalDeposit;
    }
}

