/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.utils.compare.BlockHeaderComparator;
import io.nuls.consensus.utils.manager.PunishManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.util.Iterator;
import java.util.List;

@Component
public class BlockManager {
    @Autowired
    private RoundManager roundManager;
    @Autowired
    private PunishManager punishManager;

    public void addNewBlock(Chain chain, BlockHeader blockHeader) {
        BlockHeader newestHeader = chain.getNewestHeader();
        BlockExtendsData newestExtendsData = newestHeader.getExtendsData();
        BlockExtendsData receiveExtendsData = blockHeader.getExtendsData();
        long receiveRoundIndex = receiveExtendsData.getRoundIndex();
        if (chain.getBlockHeaderList().size() > 0) {
            BlockExtendsData lastExtendsData = chain.getBlockHeaderList().get(0).getExtendsData();
            long lastRoundIndex = lastExtendsData.getRoundIndex();
            if (receiveRoundIndex > newestExtendsData.getRoundIndex() && receiveRoundIndex - 110L > lastRoundIndex) {
                Iterator<BlockHeader> iterator = chain.getBlockHeaderList().iterator();
                while (iterator.hasNext()) {
                    lastExtendsData = iterator.next().getExtendsData();
                    if (lastExtendsData.getRoundIndex() == lastRoundIndex) {
                        iterator.remove();
                        continue;
                    }
                    if (lastExtendsData.getRoundIndex() <= lastRoundIndex) continue;
                }
                this.punishManager.clear(chain);
            }
        }
        chain.getBlockHeaderList().add(blockHeader);
        chain.setNewestHeader(blockHeader);
        chain.getLogger().info("Block save, with a height of\uff1a" + blockHeader.getHeight() + " , txCount: " + blockHeader.getTxCount() + ",The latest local block height is\uff1a" + chain.getNewestHeader().getHeight() + ", Round:" + receiveExtendsData.getRoundIndex());
        this.roundManager.clearRound(chain, receiveRoundIndex);
    }

    public void chainRollBack(Chain chain, int height) {
        chain.getLogger().info("The height at which the block starts rolling back\uff1a" + height);
        List<BlockHeader> headerList = chain.getBlockHeaderList();
        headerList.sort(new BlockHeaderComparator());
        BlockHeader originalBlocHeader = chain.getNewestHeader();
        BlockExtendsData originalExtendsData = originalBlocHeader.getExtendsData();
        long originalRound = originalExtendsData.getRoundIndex();
        for (int index = headerList.size() - 1; index >= 0 && headerList.get(index).getHeight() >= (long)height; --index) {
            headerList.remove(index);
        }
        chain.setBlockHeaderList(headerList);
        chain.setNewestHeader(headerList.get(headerList.size() - 1));
        BlockHeader newestBlocHeader = chain.getNewestHeader();
        BlockExtendsData bestExtendsData = newestBlocHeader.getExtendsData();
        long currentRound = bestExtendsData.getRoundIndex();
        if (currentRound != originalRound) {
            BlockHeader lastestBlocHeader = chain.getBlockHeaderList().get(0);
            BlockExtendsData lastestExtendsData = lastestBlocHeader.getExtendsData();
            long minRound = lastestExtendsData.getRoundIndex();
            int localRoundCount = (int)(currentRound - minRound + 1L);
            int diffRoundCount = 110 - localRoundCount;
            if (diffRoundCount > 0) {
                try {
                    CallMethodUtils.getRoundBlockHeaders(chain, diffRoundCount, lastestBlocHeader.getHeight());
                }
                catch (Exception e) {
                    chain.getLogger().error(e);
                }
            }
            long roundIndex = bestExtendsData.getPackingIndexOfRound() > 1 ? bestExtendsData.getRoundIndex() : bestExtendsData.getRoundIndex() - 1L;
            this.roundManager.rollBackRound(chain, roundIndex);
        }
        chain.getLogger().info("Block rollback successful, rolled back to a height of\uff1a" + height + ",The latest local block height is\uff1a" + chain.getNewestHeader().getHeight());
    }
}

