/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.common.CommonContext;
import io.nuls.common.ConfigBean;
import io.nuls.common.NulsCoresConfig;
import io.nuls.consensus.constant.ConsensusConstant;
import io.nuls.consensus.economic.base.service.EconomicService;
import io.nuls.consensus.economic.nuls.model.bo.ConsensusConfigInfo;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.dto.CmdRegisterDto;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.utils.LoggerUtil;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.DepositManager;
import io.nuls.consensus.utils.manager.PunishManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.consensus.utils.manager.SchedulerManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.DoubleUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class ChainManager {
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private DepositManager depositManager;
    @Autowired
    private PunishManager punishManager;
    @Autowired
    private RoundManager roundManager;
    @Autowired
    private SchedulerManager schedulerManager;
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private EconomicService economicService;
    private Map<Integer, Chain> chainMap = new ConcurrentHashMap<Integer, Chain>();

    public void initChain() throws Exception {
        Map<Integer, ConfigBean> configMap = this.configChain();
        if (configMap == null || configMap.size() == 0) {
            Log.info((String)"Chain initialization failed\uff01");
            return;
        }
        for (Map.Entry<Integer, ConfigBean> entry : configMap.entrySet()) {
            Chain chain = new Chain();
            int chainId = entry.getKey();
            ConfigBean configBean = entry.getValue();
            chain.setConfig(configBean);
            this.initLogger(chain);
            this.initTable(chain);
            this.chainMap.put(chainId, chain);
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            double deflationRatio = DoubleUtils.sub((double)100.0, (double)this.config.getDeflationRatio());
            param.put("consensusConfig", new ConsensusConfigInfo(chainId, configBean.getAssetId(), configBean.getPackingInterval(), configBean.getInflationAmount(), configBean.getTotalInflationAmount(), configBean.getInitTime(), deflationRatio, configBean.getDeflationTimeInterval(), configBean.getAwardAssetId()));
            this.economicService.registerConfig(param);
        }
    }

    public void registerContractTx() {
        for (Chain chain : this.chainMap.values()) {
            int chainId = chain.getConfig().getChainId();
            ArrayList<CmdRegisterDto> cmdRegisterDtoList = new ArrayList<CmdRegisterDto>();
            CmdRegisterDto createAgentDto = new CmdRegisterDto("cs_createContractAgent", 0, List.of("packingAddress", "deposit", "commissionRate"), 1);
            CmdRegisterDto depositDto = new CmdRegisterDto("cs_contractDeposit", 0, List.of("agentHash", "deposit"), 1);
            CmdRegisterDto stopAgentDto = new CmdRegisterDto("cs_stopContractAgent", 0, List.of(), 1);
            CmdRegisterDto cancelDepositDto = new CmdRegisterDto("cs_contractWithdraw", 0, List.of("joinAgentHash"), 1);
            CmdRegisterDto searchAgentInfo = new CmdRegisterDto("cs_getContractAgentInfo", 1, List.of("agentHash"), 1);
            CmdRegisterDto searchDepositInfo = new CmdRegisterDto("cs_getContractDepositInfo", 1, List.of("joinAgentHash"), 1);
            cmdRegisterDtoList.add(cancelDepositDto);
            cmdRegisterDtoList.add(createAgentDto);
            cmdRegisterDtoList.add(stopAgentDto);
            cmdRegisterDtoList.add(depositDto);
            cmdRegisterDtoList.add(searchAgentInfo);
            cmdRegisterDtoList.add(searchDepositInfo);
            CallMethodUtils.registerContractTx(chainId, cmdRegisterDtoList);
        }
    }

    public void runChain() {
        for (Chain chain : this.chainMap.values()) {
            this.initCache(chain);
            this.schedulerManager.createChainScheduler(chain);
        }
    }

    public void stopChain(int chainId) {
    }

    public void deleteChain(int chainId) {
    }

    private Map<Integer, ConfigBean> configChain() {
        try {
            Map<Integer, ConfigBean> configMap = CommonContext.CONFIG_BEAN_MAP;
            if (configMap == null || configMap.size() == 0) {
                NulsCoresConfig configBean = this.config;
                configBean.setBlockReward(configBean.getInflationAmount().divide(ConsensusConstant.YEAR_MILLISECOND.divide(BigInteger.valueOf(configBean.getPackingInterval()))));
                configMap.put(((ConfigBean)configBean).getChainId(), configBean);
            }
            return configMap;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    private void initTable(Chain chain) {
        int chainId = chain.getConfig().getChainId();
        try {
            RocksDBService.createTable((String)("consensus_agent" + chainId));
            RocksDBService.createTable((String)("consensus_deposit" + chainId));
            RocksDBService.createTable((String)("consensus_punish" + chainId));
            RocksDBService.createTable((String)("random_seed" + chainId));
        }
        catch (Exception e) {
            if (!"DB table exists".equals(e.getMessage())) {
                chain.getLogger().error(e.getMessage());
            }
            chain.getLogger().error(e.getMessage());
        }
    }

    private void initLogger(Chain chain) {
        LoggerUtil.initLogger(chain);
    }

    private void initCache(Chain chain) {
        try {
            CallMethodUtils.loadBlockHeader(chain);
            this.agentManager.loadAgents(chain);
            this.depositManager.loadDeposits(chain);
            this.punishManager.loadPunishes(chain);
            if (chain.getBlockHeaderList().size() > 1) {
                this.roundManager.initRound(chain);
            }
            chain.setCacheLoaded(true);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
    }

    public Map<Integer, Chain> getChainMap() {
        return this.chainMap;
    }

    public void setChainMap(Map<Integer, Chain> chainMap) {
        this.chainMap = chainMap;
    }
}

