/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.BigIntegerUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class CoinDataManager {
    public CoinData getCoinData(byte[] address, Chain chain, BigInteger amount, long lockTime, int txSize, int assetChainId, int assetId) throws NulsException {
        CoinData coinData = new CoinData();
        CoinTo to = new CoinTo(address, assetChainId, assetId, amount, lockTime);
        coinData.addTo(to);
        txSize += to.size();
        Map<String, Object> result = CallMethodUtils.getBalanceAndNonce(chain, AddressTool.getStringAddressByBytes((byte[])address), assetChainId, assetId);
        byte[] nonce = RPCUtil.decode((String)((String)result.get("nonce")));
        BigInteger available = new BigInteger(result.get("available").toString());
        CoinFrom from = new CoinFrom(address, assetChainId, assetId, amount, nonce, 0);
        BigInteger fee = TransactionFeeCalculator.getConsensusTxFee((int)(txSize += from.size()), (long)chain.getConfig().getFeeUnit(assetChainId, assetId));
        BigInteger fromAmount = amount.add(fee);
        if (BigIntegerUtils.isLessThan((BigInteger)available, (BigInteger)fromAmount)) {
            throw new NulsException(ConsensusErrorCode.BANANCE_NOT_ENNOUGH);
        }
        from.setAmount(fromAmount);
        coinData.addFrom(from);
        return coinData;
    }

    public CoinData getContractCoinData(byte[] address, Chain chain, BigInteger amount, long lockTime, byte[] nonce, BigInteger available) throws NulsException {
        CoinData coinData = new CoinData();
        CoinTo to = new CoinTo(address, chain.getConfig().getChainId(), chain.getConfig().getAssetId(), amount, lockTime);
        coinData.addTo(to);
        CoinFrom from = new CoinFrom(address, chain.getConfig().getChainId(), chain.getConfig().getAssetId(), amount, nonce, 0);
        if (BigIntegerUtils.isLessThan((BigInteger)available, (BigInteger)amount)) {
            throw new NulsException(ConsensusErrorCode.BANANCE_NOT_ENNOUGH);
        }
        coinData.addFrom(from);
        return coinData;
    }

    public CoinData getUnlockCoinData(byte[] address, Chain chain, BigInteger amount, long lockTime, int txSize) throws NulsException {
        int agentChainId = chain.getConfig().getAgentChainId();
        int agentAssetId = chain.getConfig().getAssetId();
        Map<String, Object> balanceMap = CallMethodUtils.getBalance(chain, AddressTool.getStringAddressByBytes((byte[])address), agentChainId, agentAssetId);
        BigInteger freeze = new BigInteger(balanceMap.get("freeze").toString());
        if (BigIntegerUtils.isLessThan((BigInteger)freeze, (BigInteger)amount)) {
            throw new NulsException(ConsensusErrorCode.BANANCE_NOT_ENNOUGH);
        }
        CoinData coinData = new CoinData();
        CoinTo to = new CoinTo(address, agentChainId, agentAssetId, amount, lockTime);
        coinData.addTo(to);
        txSize += to.size();
        CoinFrom from = new CoinFrom(address, agentChainId, agentAssetId, amount, -1);
        coinData.addFrom(from);
        BigInteger fee = TransactionFeeCalculator.getConsensusTxFee((int)(txSize += from.size()), (long)chain.getConfig().getFeeUnit(agentChainId, agentAssetId));
        BigInteger realToAmount = amount.subtract(fee);
        to.setAmount(realToAmount);
        return coinData;
    }

    public CoinData getContractUnlockCoinData(byte[] address, Chain chain, BigInteger amount, long lockTime) throws NulsException {
        Map<String, Object> balanceMap = CallMethodUtils.getBalance(chain, AddressTool.getStringAddressByBytes((byte[])address), chain.getConfig().getChainId(), chain.getConfig().getAssetId());
        BigInteger freeze = new BigInteger(balanceMap.get("freeze").toString());
        if (BigIntegerUtils.isLessThan((BigInteger)freeze, (BigInteger)amount)) {
            throw new NulsException(ConsensusErrorCode.BANANCE_NOT_ENNOUGH);
        }
        CoinData coinData = new CoinData();
        CoinTo to = new CoinTo(address, chain.getConfig().getChainId(), chain.getConfig().getAssetId(), amount, lockTime);
        coinData.addTo(to);
        CoinFrom from = new CoinFrom(address, chain.getConfig().getChainId(), chain.getConfig().getAssetId(), amount, -1);
        coinData.addFrom(from);
        to.setAmount(amount);
        return coinData;
    }

    public CoinData getStopAgentCoinData(Chain chain, byte[] address, long lockTime) throws NulsException {
        List<Agent> agentList = chain.getAgentList();
        for (Agent agent : agentList) {
            if (agent.getDelHeight() > 0L || !Arrays.equals(address, agent.getAgentAddress())) continue;
            return this.getStopAgentCoinData(chain, agent, lockTime);
        }
        return null;
    }

    public CoinData getStopAgentCoinData(Chain chain, Agent agent, long lockTime) throws NulsException {
        return this.getStopAgentCoinData(chain, agent, lockTime, null);
    }

    private CoinData getStopAgentCoinData(Chain chain, Agent agent, long lockTime, Long height) throws NulsException {
        if (null == agent) {
            return null;
        }
        try {
            int agentChainId = chain.getConfig().getAgentChainId();
            int agentAssetId = chain.getConfig().getAgentAssetId();
            NulsHash createTxHash = agent.getTxHash();
            Transaction createAgentTransaction = CallMethodUtils.getTransaction(chain, createTxHash.toHex());
            if (null == createAgentTransaction) {
                throw new NulsRuntimeException(ConsensusErrorCode.TX_NOT_EXIST);
            }
            CoinData coinData = new CoinData();
            ArrayList<Object> toList = new ArrayList<Object>();
            ArrayList<CoinFrom> fromList = new ArrayList<CoinFrom>();
            toList.add(new CoinTo(agent.getAgentAddress(), agentChainId, agentAssetId, agent.getDeposit(), lockTime));
            CoinData createCoinData = new CoinData();
            createCoinData.parse(createAgentTransaction.getCoinData(), 0);
            for (CoinTo to : createCoinData.getTo()) {
                CoinFrom from = new CoinFrom(agent.getAgentAddress(), agentChainId, agentAssetId);
                if (to.getAmount().compareTo(agent.getDeposit()) != 0 || to.getLockTime() != -1L) continue;
                from.setAmount(to.getAmount());
                from.setLocked((byte)-1);
                from.setNonce(CallMethodUtils.getNonce(createTxHash.getBytes()));
                fromList.add(from);
            }
            if (fromList.isEmpty()) {
                throw new NulsRuntimeException(ConsensusErrorCode.DATA_ERROR);
            }
            coinData.setFrom(fromList);
            List<Deposit> deposits = chain.getDepositList();
            HashMap<String, CoinTo> toMap = new HashMap<String, CoinTo>(16);
            long blockHeight = null == height ? -1L : height;
            for (Deposit deposit : deposits) {
                String address;
                CoinTo coinTo;
                if (deposit.getDelHeight() > 0L && (blockHeight <= 0L || deposit.getDelHeight() < blockHeight) || !deposit.getAgentHash().equals((Object)agent.getTxHash())) continue;
                Transaction depositTransaction = CallMethodUtils.getTransaction(chain, deposit.getTxHash().toHex());
                CoinData depositCoinData = new CoinData();
                depositCoinData.parse(depositTransaction.getCoinData(), 0);
                for (CoinTo to : depositCoinData.getTo()) {
                    if (!BigIntegerUtils.isEqual((BigInteger)to.getAmount(), (BigInteger)deposit.getDeposit()) || to.getLockTime() != -1L) continue;
                    byte[] nonce = CallMethodUtils.getNonce(deposit.getTxHash().getBytes());
                    CoinFrom from = new CoinFrom(deposit.getAddress(), agentChainId, agentAssetId, to.getAmount(), nonce, -1);
                    fromList.add(from);
                    break;
                }
                if ((coinTo = (CoinTo)toMap.get(address = AddressTool.getStringAddressByBytes((byte[])deposit.getAddress()))) == null) {
                    coinTo = new CoinTo(deposit.getAddress(), agentChainId, agentAssetId, deposit.getDeposit(), 0L);
                    toMap.put(address, coinTo);
                    continue;
                }
                coinTo.setAmount(coinTo.getAmount().add(deposit.getDeposit()));
            }
            toList.addAll(toMap.values());
            coinData.setTo(toList);
            return coinData;
        }
        catch (NulsException e) {
            chain.getLogger().error(e.getMessage());
            throw e;
        }
    }

    public boolean hasContractAddress(CoinData coinData, int chainId) {
        for (CoinTo coinTo : coinData.getTo()) {
            if (!AddressTool.validContractAddress((byte[])coinTo.getAddress(), (int)chainId)) continue;
            return true;
        }
        return false;
    }
}

