/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;

@Component
public class FixRedPunishBugHelper {
    @Autowired
    private AgentStorageService agentStorageService;

    public void v13Filter(int chainId, Agent agent, long startBlockHeight) {
        this.execute(chainId, "15673a9ab94fd5737ec541e3d6b289ea119268b361f0bfbe86b69a95f83c196f", startBlockHeight, 3718800L, agent);
        this.execute(chainId, "a27170a4ad246758cc7fb45ded14b065f6a1919836a2bba34e6dcd9335a054da", startBlockHeight, 8083986L, agent);
        this.execute(chainId, "ad82dc5237378a39abb3bbd8174ac0f77c882573a02c8fac01b4c7a058a96d90", startBlockHeight, 8083892L, agent);
        this.execute(chainId, "d11d29e38b3db75aec0ebb69dc66eb4f6276d0a1d9c7faa6a4fa33b699637447", startBlockHeight, 8084009L, agent);
    }

    private void execute(int chainId, String hash, long startBlockHeight, long deleteHeight, Agent agent) {
        if (deleteHeight > startBlockHeight) {
            return;
        }
        if (agent.getDelHeight() == deleteHeight) {
            return;
        }
        if (!hash.equals(agent.getTxHash().toHex())) {
            return;
        }
        agent.setDelHeight(deleteHeight);
        agent.setStatus(0);
        AgentPo po = this.agentStorageService.get(agent.getTxHash(), chainId);
        if (null == po) {
            return;
        }
        po.setDelHeight(deleteHeight);
        this.agentStorageService.save(po, chainId);
        Log.warn((String)("update special agent:" + hash));
    }
}

