/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.RedPunishData;
import io.nuls.base.data.SmallBlock;
import io.nuls.base.data.Transaction;
import io.nuls.base.data.YellowPunishData;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.consensus.Evidence;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.CancelDeposit;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.model.po.PunishLogPo;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.consensus.storage.PunishStorageService;
import io.nuls.consensus.utils.compare.PunishLogComparator;
import io.nuls.consensus.utils.enumeration.PunishReasonEnum;
import io.nuls.consensus.utils.enumeration.PunishType;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.CoinDataManager;
import io.nuls.consensus.utils.manager.DepositManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.core.basic.VarInt;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.DoubleUtils;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public class PunishManager {
    @Autowired
    private PunishStorageService punishStorageService;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    private AgentStorageService agentStorageService;
    @Autowired
    private DepositStorageService depositStorageService;
    @Autowired
    private DepositManager depositManager;
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private RoundManager roundManager;

    public void loadPunishes(Chain chain) throws Exception {
        BlockHeader blockHeader = chain.getNewestHeader();
        if (null == blockHeader) {
            return;
        }
        BlockExtendsData roundData = blockHeader.getExtendsData();
        long breakRoundIndex = roundData.getRoundIndex() - 400L;
        List<PunishLogPo> punishLogList = this.punishStorageService.getPunishList(chain.getConfig().getChainId());
        ArrayList<PunishLogPo> redPunishList = new ArrayList<PunishLogPo>();
        ArrayList<PunishLogPo> yellowPunishList = new ArrayList<PunishLogPo>();
        for (PunishLogPo po : punishLogList) {
            if (po.getType() == PunishType.RED.getCode()) {
                redPunishList.add(po);
                continue;
            }
            if (po.getRoundIndex() <= breakRoundIndex) continue;
            yellowPunishList.add(po);
        }
        Collections.sort(redPunishList, new PunishLogComparator());
        Collections.sort(yellowPunishList, new PunishLogComparator());
        chain.setRedPunishList(redPunishList);
        chain.setYellowPunishList(yellowPunishList);
    }

    public void clear(Chain chain) {
        PunishLogPo punishLogPo;
        BlockHeader blockHeader = chain.getNewestHeader();
        BlockExtendsData roundData = blockHeader.getExtendsData();
        Iterator<PunishLogPo> iterator = chain.getYellowPunishList().iterator();
        long minRound = roundData.getRoundIndex() - 400L;
        while (iterator.hasNext() && (punishLogPo = iterator.next()).getRoundIndex() < minRound) {
            iterator.remove();
        }
    }

    public void addEvidenceRecord(Chain chain, BlockHeader firstHeader, BlockHeader secondHeader) throws NulsException {
        Agent agent = null;
        for (Agent a : chain.getAgentList()) {
            if (a.getDelHeight() > 0L || !Arrays.equals(a.getPackingAddress(), firstHeader.getPackingAddress(chain.getConfig().getChainId()))) continue;
            agent = a;
            break;
        }
        if (null == agent) {
            return;
        }
        boolean isRedPunish = this.isRedPunish(chain, firstHeader, secondHeader);
        if (isRedPunish) {
            this.createRedPunishTransaction(chain, agent);
        }
    }

    public void addDoubleSpendRecord(Chain chain, List<Transaction> txs, Block block) throws NulsException {
        byte[] packingAddress = AddressTool.getAddress((byte[])block.getHeader().getBlockSignature().getPublicKey(), (int)chain.getConfig().getChainId());
        List<Agent> agentList = chain.getAgentList();
        Agent agent = null;
        for (Agent a : agentList) {
            if (a.getDelHeight() > 0L || !Arrays.equals(a.getPackingAddress(), packingAddress)) continue;
            agent = a;
            break;
        }
        if (agent == null) {
            return;
        }
        try {
            Transaction redPunishTransaction = new Transaction(8);
            RedPunishData redPunishData = new RedPunishData();
            redPunishData.setAddress(agent.getAgentAddress());
            SmallBlock smallBlock = new SmallBlock();
            smallBlock.setHeader(block.getHeader());
            smallBlock.setTxHashList((ArrayList)block.getTxHashList());
            for (Transaction tx : txs) {
                smallBlock.addSystemTx(tx);
            }
            redPunishData.setEvidence(smallBlock.serialize());
            redPunishData.setReasonCode(PunishReasonEnum.DOUBLE_SPEND.getCode());
            redPunishTransaction.setTxData(redPunishData.serialize());
            redPunishTransaction.setTime(smallBlock.getHeader().getTime());
            CoinData coinData = this.coinDataManager.getStopAgentCoinData(chain, agent, redPunishTransaction.getTime() + chain.getConfig().getRedPublishLockTime());
            redPunishTransaction.setCoinData(coinData.serialize());
            redPunishTransaction.setHash(NulsHash.calcHash((byte[])redPunishTransaction.serializeForHash()));
            chain.getRedPunishTransactionList().add(redPunishTransaction);
        }
        catch (IOException e) {
            chain.getLogger().error(e.getMessage());
        }
    }

    private boolean isRedPunish(Chain chain, BlockHeader firstHeader, BlockHeader secondHeader) {
        String packingAddress = AddressTool.getStringAddressByBytes((byte[])firstHeader.getPackingAddress(chain.getConfig().getChainId()));
        BlockExtendsData extendsData = firstHeader.getExtendsData();
        long currentRoundIndex = extendsData.getRoundIndex();
        Map<String, List<Evidence>> currentChainEvidences = chain.getEvidenceMap();
        Evidence evidence = new Evidence(currentRoundIndex, firstHeader, secondHeader);
        if (currentChainEvidences == null) {
            currentChainEvidences = new HashMap<String, List<Evidence>>(16);
        }
        if (!currentChainEvidences.containsKey(packingAddress)) {
            ArrayList<Evidence> list = new ArrayList<Evidence>();
            list.add(evidence);
            currentChainEvidences.put(packingAddress, list);
            return false;
        }
        List<Evidence> list = currentChainEvidences.get(packingAddress);
        Iterator<Evidence> iterator = list.iterator();
        while (iterator.hasNext()) {
            Evidence e = iterator.next();
            if (e.getRoundIndex() > currentRoundIndex - 100L) continue;
            iterator.remove();
        }
        list.add(evidence);
        currentChainEvidences.put(packingAddress, list);
        chain.setEvidenceMap(currentChainEvidences);
        return list.size() >= 3;
    }

    private void createRedPunishTransaction(Chain chain, Agent agent) throws NulsException {
        Transaction redPunishTransaction = new Transaction(8);
        RedPunishData redPunishData = new RedPunishData();
        redPunishData.setAddress(agent.getAgentAddress());
        long txTime = 0L;
        try {
            byte[][] headers = new byte[6][];
            Map<String, List<Evidence>> currentChainEvidences = chain.getEvidenceMap();
            List<Evidence> list = currentChainEvidences.remove(AddressTool.getStringAddressByBytes((byte[])agent.getPackingAddress()));
            for (int i = 0; i < list.size() && i < 3; ++i) {
                Evidence evidence = list.get(i);
                int s = i * 2;
                headers[s] = evidence.getBlockHeader1().serialize();
                headers[++s] = evidence.getBlockHeader2().serialize();
                txTime = (evidence.getBlockHeader1().getTime() + evidence.getBlockHeader2().getTime()) / 2L;
            }
            redPunishData.setEvidence(ByteUtils.concatenate((byte[][])headers));
        }
        catch (IOException e) {
            chain.getLogger().error(e.getMessage());
        }
        try {
            redPunishData.setReasonCode(PunishReasonEnum.BIFURCATION.getCode());
            redPunishTransaction.setTxData(redPunishData.serialize());
            redPunishTransaction.setTime(txTime);
            CoinData coinData = this.coinDataManager.getStopAgentCoinData(chain, agent, redPunishTransaction.getTime() + chain.getConfig().getRedPublishLockTime());
            redPunishTransaction.setCoinData(coinData.serialize());
            redPunishTransaction.setHash(NulsHash.calcHash((byte[])redPunishTransaction.serializeForHash()));
            chain.getRedPunishTransactionList().add(redPunishTransaction);
        }
        catch (IOException e) {
            chain.getLogger().error(e.getMessage());
        }
    }

    public void punishTx(Chain chain, BlockHeader bestBlock, List<Transaction> txList, MeetingMember self, MeetingRound round) throws Exception {
        Transaction yellowPunishTransaction = this.createYellowPunishTx(chain, bestBlock, self, round);
        if (null == yellowPunishTransaction) {
            if (chain.getRedPunishTransactionList().size() > 0) {
                this.conflictValid(chain, txList);
            }
            return;
        }
        txList.add(yellowPunishTransaction);
        YellowPunishData yellowPunishData = new YellowPunishData();
        yellowPunishData.parse(yellowPunishTransaction.getTxData(), 0);
        List addressList = yellowPunishData.getAddressList();
        HashSet<Integer> punishedSet = new HashSet<Integer>();
        for (byte[] address : addressList) {
            boolean changeNet;
            MeetingMember member = round.getMemberByAgentAddress(address);
            if (null == member) {
                member = round.getPreRound().getMemberByAgentAddress(address);
            }
            if ((changeNet = bestBlock.getHeight() >= 878000L && bestBlock.getHeight() <= 900000L) || DoubleUtils.compare((double)member.getAgent().getRealCreditVal(), (double)-1.0) > 0 || !punishedSet.add(member.getPackingIndexOfRound()) || member.getAgent().getDelHeight() > 0L) continue;
            Transaction redPunishTransaction = new Transaction(8);
            RedPunishData redPunishData = new RedPunishData();
            redPunishData.setAddress(address);
            redPunishData.setReasonCode(PunishReasonEnum.TOO_MUCH_YELLOW_PUNISH.getCode());
            redPunishTransaction.setTxData(redPunishData.serialize());
            redPunishTransaction.setTime(self.getPackEndTime());
            CoinData coinData = this.coinDataManager.getStopAgentCoinData(chain, redPunishData.getAddress(), redPunishTransaction.getTime() + chain.getConfig().getRedPublishLockTime());
            if (coinData == null) continue;
            redPunishTransaction.setCoinData(coinData.serialize());
            redPunishTransaction.setHash(NulsHash.calcHash((byte[])redPunishTransaction.serializeForHash()));
            chain.getRedPunishTransactionList().add(redPunishTransaction);
        }
        if (chain.getRedPunishTransactionList().size() > 0) {
            this.conflictValid(chain, txList);
        }
    }

    public Transaction createYellowPunishTx(Chain chain, BlockHeader preBlock, MeetingMember self, MeetingRound round) throws Exception {
        BlockExtendsData preBlockRoundData = preBlock.getExtendsData();
        if (self.getRoundIndex() - preBlockRoundData.getRoundIndex() > 1L) {
            return null;
        }
        int yellowCount = 0;
        if (self.getRoundIndex() == preBlockRoundData.getRoundIndex() && self.getPackingIndexOfRound() != preBlockRoundData.getPackingIndexOfRound() + 1) {
            yellowCount = self.getPackingIndexOfRound() - preBlockRoundData.getPackingIndexOfRound() - 1;
        }
        if (self.getRoundIndex() != preBlockRoundData.getRoundIndex() && (self.getPackingIndexOfRound() != 1 || preBlockRoundData.getPackingIndexOfRound() != preBlockRoundData.getConsensusMemberCount())) {
            yellowCount = self.getPackingIndexOfRound() + preBlockRoundData.getConsensusMemberCount() - preBlockRoundData.getPackingIndexOfRound() - 1;
        }
        if (yellowCount == 0) {
            return null;
        }
        ArrayList<byte[]> addressList = new ArrayList<byte[]>();
        for (int i = 1; i <= yellowCount; ++i) {
            MeetingMember member;
            int index = self.getPackingIndexOfRound() - i;
            if (index > 0) {
                member = round.getMember(index);
                if (member.getAgent() == null || member.getAgent().getDelHeight() > 0L || member.getAgent().getDeposit().equals(BigInteger.ZERO)) continue;
                addressList.add(member.getAgent().getAgentAddress());
                continue;
            }
            MeetingRound preRound = round.getPreRound();
            if (preRound == null) {
                if (chain.getRoundList().size() > 0) {
                    preRound = this.roundManager.getRoundByIndex(chain, round.getIndex() - 1L);
                }
                if (preRound == null) {
                    preRound = this.roundManager.getPreRound(chain, round.getIndex());
                }
            }
            if (preRound == null || (member = preRound.getMember(index + preRound.getMemberCount())).getAgent() == null || member.getAgent().getDelHeight() > 0L || member.getAgent().getDeposit().equals(BigInteger.ZERO)) continue;
            addressList.add(member.getAgent().getAgentAddress());
        }
        if (addressList.isEmpty()) {
            return null;
        }
        Transaction punishTx = new Transaction(7);
        YellowPunishData data = new YellowPunishData();
        data.setAddressList(addressList);
        punishTx.setTxData(data.serialize());
        punishTx.setTime(self.getPackEndTime());
        punishTx.setHash(NulsHash.calcHash((byte[])punishTx.serializeForHash()));
        return punishTx;
    }

    private void conflictValid(Chain chain, List<Transaction> txList) throws NulsException {
        Set<String> redPunishAddressSet = this.redPunishAddressSet(chain);
        if (redPunishAddressSet.isEmpty()) {
            return;
        }
        Iterator<Transaction> iterator = txList.iterator();
        HashSet<NulsHash> invalidAgentTxHash = new HashSet<NulsHash>();
        HashSet<NulsHash> invalidDepositTxHash = new HashSet<NulsHash>();
        block6: while (iterator.hasNext()) {
            Transaction tx = iterator.next();
            switch (tx.getType()) {
                case 4: {
                    Agent agent = new Agent();
                    agent.parse(tx.getTxData(), 0);
                    if (!redPunishAddressSet.contains(HexUtil.encode((byte[])agent.getPackingAddress())) && !redPunishAddressSet.contains(HexUtil.encode((byte[])agent.getAgentAddress()))) continue block6;
                    invalidAgentTxHash.add(agent.getTxHash());
                    iterator.remove();
                    continue block6;
                }
                case 9: {
                    StopAgent stopAgent = new StopAgent();
                    stopAgent.parse(tx.getTxData(), 0);
                    if (!invalidAgentTxHash.contains(stopAgent.getCreateTxHash())) continue block6;
                    iterator.remove();
                    continue block6;
                }
                case 5: {
                    Deposit deposit = new Deposit();
                    deposit.parse(tx.getTxData(), 0);
                    if (!invalidAgentTxHash.contains(deposit.getAgentHash())) continue block6;
                    invalidDepositTxHash.add(deposit.getTxHash());
                    iterator.remove();
                    continue block6;
                }
                case 6: {
                    CancelDeposit cancelDeposit = new CancelDeposit();
                    cancelDeposit.parse(tx.getTxData(), 0);
                    if (!invalidDepositTxHash.contains(cancelDeposit.getJoinTxHash())) continue block6;
                    iterator.remove();
                    continue block6;
                }
            }
        }
        txList.addAll(chain.getRedPunishTransactionList());
        chain.getRedPunishTransactionList().clear();
    }

    private Set<String> redPunishAddressSet(Chain chain) throws NulsException {
        HashSet<String> redPunishAddressSet = new HashSet<String>();
        RedPunishData redPunishData = new RedPunishData();
        Iterator<Transaction> iterator = chain.getRedPunishTransactionList().iterator();
        while (iterator.hasNext()) {
            Transaction redPunishTx = iterator.next();
            redPunishData.parse(redPunishTx.getTxData(), 0);
            Agent agent = this.agentManager.getAgentByAgentAddress(chain, redPunishData.getAddress());
            if (agent == null || agent.getDelHeight() > 0L) {
                iterator.remove();
                continue;
            }
            redPunishAddressSet.add(HexUtil.encode((byte[])redPunishData.getAddress()));
        }
        return redPunishAddressSet;
    }

    public boolean redPunishCommit(Transaction tx, Chain chain, BlockHeader blockHeader) throws NulsException {
        long blockHeight = blockHeader.getHeight();
        int chainId = chain.getConfig().getChainId();
        RedPunishData punishData = new RedPunishData();
        punishData.parse(tx.getTxData(), 0);
        BlockExtendsData roundData = blockHeader.getExtendsData();
        PunishLogPo punishLogPo = new PunishLogPo();
        punishLogPo.setAddress(punishData.getAddress());
        punishLogPo.setHeight(blockHeight);
        punishLogPo.setRoundIndex(roundData.getRoundIndex());
        punishLogPo.setTime(tx.getTime());
        punishLogPo.setType(PunishType.RED.getCode());
        punishLogPo.setEvidence(punishData.getEvidence());
        punishLogPo.setReasonCode(punishData.getReasonCode());
        List<AgentPo> agentList = this.agentStorageService.getList(chainId);
        AgentPo agent = null;
        for (AgentPo agentPo : agentList) {
            if (agentPo.getDelHeight() > 0L || !Arrays.equals(agentPo.getAgentAddress(), punishLogPo.getAddress())) continue;
            agent = agentPo;
            break;
        }
        if (null == agent) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        List<DepositPo> depositPoList = this.depositStorageService.getList(chainId);
        ArrayList<Object> updatedList = new ArrayList<Object>();
        for (Object po : depositPoList) {
            if (po.getDelHeight() >= 0L || !po.getAgentHash().equals((Object)agent.getHash())) continue;
            po.setDelHeight(blockHeight);
            boolean bl = this.depositStorageService.save((DepositPo)((Object)po), chainId);
            if (!bl) {
                for (DepositPo depositPo : updatedList) {
                    depositPo.setDelHeight(-1L);
                    this.depositStorageService.save(depositPo, chainId);
                }
                throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
            }
            updatedList.add(po);
        }
        boolean success = this.punishStorageService.save(punishLogPo, chainId);
        if (!success) {
            for (DepositPo depositPo : updatedList) {
                depositPo.setDelHeight(-1L);
                this.depositStorageService.save(depositPo, chainId);
            }
            throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
        }
        AgentPo agentPo = agent;
        agentPo.setDelHeight(blockHeight);
        success = this.agentStorageService.save(agentPo, chainId);
        if (!success) {
            for (DepositPo depositPo : updatedList) {
                depositPo.setDelHeight(-1L);
                this.depositStorageService.save(depositPo, chainId);
            }
            this.punishStorageService.delete(punishLogPo.getKey(), chainId);
            throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
        }
        if (!updatedList.isEmpty()) {
            for (DepositPo depositPo : updatedList) {
                this.depositManager.updateDeposit(chain, this.depositManager.poToDeposit(depositPo));
            }
        }
        chain.getRedPunishList().add(punishLogPo);
        this.agentManager.updateAgent(chain, this.agentManager.poToAgent(agentPo));
        return true;
    }

    public boolean redPunishRollback(Transaction tx, Chain chain, BlockHeader blockHeader) throws NulsException {
        long blockHeight = blockHeader.getHeight();
        int chainId = chain.getConfig().getChainId();
        RedPunishData punishData = new RedPunishData();
        punishData.parse(tx.getTxData(), 0);
        List<AgentPo> agentList = this.agentStorageService.getList(chainId);
        AgentPo agent = null;
        for (AgentPo agentPo : agentList) {
            if (agentPo.getDelHeight() <= 0L || !Arrays.equals(agentPo.getAgentAddress(), punishData.getAddress())) continue;
            agent = agentPo;
            break;
        }
        if (null == agent) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        List<DepositPo> depositPoList = this.depositStorageService.getList(chainId);
        ArrayList<DepositPo> updatedList = new ArrayList<DepositPo>();
        for (DepositPo po : depositPoList) {
            boolean success;
            if (!po.getAgentHash().equals((Object)agent.getHash())) continue;
            if (po.getDelHeight() == blockHeight) {
                po.setDelHeight(-1L);
            }
            if (!(success = this.depositStorageService.save(po, chainId))) {
                for (DepositPo po2 : updatedList) {
                    po2.setDelHeight(blockHeight);
                    this.depositStorageService.save(po2, chainId);
                }
                throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
            }
            updatedList.add(po);
        }
        AgentPo agentPo = agent;
        agentPo.setDelHeight(-1L);
        boolean success = this.agentStorageService.save(agentPo, chainId);
        if (!success) {
            for (DepositPo po2 : depositPoList) {
                po2.setDelHeight(blockHeight);
                this.depositStorageService.save(po2, chainId);
            }
            throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
        }
        byte[] key = ByteUtils.concatenate((byte[][])new byte[][]{punishData.getAddress(), {PunishType.RED.getCode()}, SerializeUtils.uint64ToByteArray((long)blockHeight), {0}});
        success = this.punishStorageService.delete(key, chainId);
        if (!success) {
            for (DepositPo po2 : depositPoList) {
                po2.setDelHeight(blockHeight);
                this.depositStorageService.save(po2, chainId);
            }
            agentPo.setDelHeight(blockHeight);
            this.agentStorageService.save(agentPo, chainId);
            throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
        }
        if (!updatedList.isEmpty()) {
            for (DepositPo po2 : updatedList) {
                this.depositManager.updateDeposit(chain, this.depositManager.poToDeposit(po2));
            }
        }
        this.agentManager.updateAgent(chain, this.agentManager.poToAgent(agentPo));
        return true;
    }

    public boolean yellowPunishCommit(Transaction tx, Chain chain, BlockHeader blockHeader) throws NulsException {
        YellowPunishData punishData = new YellowPunishData();
        punishData.parse(tx.getTxData(), 0);
        BlockExtendsData roundData = blockHeader.getExtendsData();
        ArrayList<PunishLogPo> savedList = new ArrayList<PunishLogPo>();
        int index = 1;
        int chainId = chain.getConfig().getChainId();
        for (byte[] address : punishData.getAddressList()) {
            PunishLogPo po = new PunishLogPo();
            po.setAddress(address);
            po.setHeight(blockHeader.getHeight());
            po.setRoundIndex(roundData.getRoundIndex());
            po.setTime(tx.getTime());
            po.setIndex(index++);
            po.setType(PunishType.YELLOW.getCode());
            boolean result = this.punishStorageService.save(po, chainId);
            if (!result) {
                for (PunishLogPo punishLogPo : savedList) {
                    this.punishStorageService.delete(this.getPoKey(punishLogPo.getAddress(), PunishType.YELLOW.getCode(), punishLogPo.getHeight(), punishLogPo.getIndex()), chainId);
                }
                savedList.clear();
                throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
            }
            savedList.add(po);
        }
        chain.getYellowPunishList().addAll(savedList);
        return true;
    }

    public boolean yellowPunishRollback(Transaction tx, Chain chain, BlockHeader blockHeader) throws NulsException {
        long blockHeight = blockHeader.getHeight();
        YellowPunishData punishData = new YellowPunishData();
        punishData.parse(tx.getTxData(), 0);
        ArrayList<PunishLogPo> deletedList = new ArrayList<PunishLogPo>();
        BlockExtendsData roundData = blockHeader.getExtendsData();
        int deleteIndex = 1;
        int chainId = chain.getConfig().getChainId();
        for (byte[] address : punishData.getAddressList()) {
            boolean result = this.punishStorageService.delete(this.getPoKey(address, PunishType.YELLOW.getCode(), blockHeight, deleteIndex), chainId);
            if (!result) {
                for (PunishLogPo po : deletedList) {
                    this.punishStorageService.save(po, chainId);
                }
                deletedList.clear();
                throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
            }
            PunishLogPo po = new PunishLogPo();
            po.setAddress(address);
            po.setHeight(blockHeight);
            po.setRoundIndex(roundData.getRoundIndex());
            po.setTime(tx.getTime());
            po.setIndex(deleteIndex);
            po.setType(PunishType.YELLOW.getCode());
            deletedList.add(po);
            ++deleteIndex;
        }
        chain.getYellowPunishList().removeAll(deletedList);
        return true;
    }

    private byte[] getPoKey(byte[] address, byte type, long blockHeight, int index) {
        return ByteUtils.concatenate((byte[][])new byte[][]{address, {type}, SerializeUtils.uint64ToByteArray((long)blockHeight), new VarInt((long)index).encode()});
    }
}

