/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.thread.process;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.ProtocolVersion;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ModuleHelper;
import io.nuls.consensus.constant.ConsensusConstant;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.BlockData;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.po.RandomSeedStatusPo;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.storage.RandomSeedsStorageService;
import io.nuls.consensus.utils.RandomSeedUtils;
import io.nuls.consensus.utils.enumeration.ConsensusStatus;
import io.nuls.consensus.utils.manager.ConsensusManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ConsensusProcess {
    private RoundManager roundManager = (RoundManager)SpringLiteContext.getBean(RoundManager.class);
    private RandomSeedsStorageService randomSeedsStorageService = (RandomSeedsStorageService)SpringLiteContext.getBean(RandomSeedsStorageService.class);
    private NulsLogger consensusLogger;
    private boolean hasPacking;

    public void process(Chain chain) {
        try {
            boolean canPackage = this.checkCanPackage(chain);
            if (!canPackage) {
                return;
            }
            this.consensusLogger = chain.getLogger();
            this.doWork(chain);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
    }

    private boolean checkCanPackage(Chain chain) throws Exception {
        if (chain == null) {
            throw new NulsException(ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        if (chain.getConsensusStatus().ordinal() <= ConsensusStatus.WAIT_RUNNING.ordinal()) {
            return false;
        }
        return chain.isCanPacking();
    }

    private void doWork(Chain chain) throws Exception {
        if (chain.getConsensusStatus().ordinal() < ConsensusStatus.RUNNING.ordinal()) {
            return;
        }
        MeetingRound round = this.roundManager.resetRound(chain, true);
        if (round == null) {
            return;
        }
        MeetingMember member = round.getMyMember();
        if (member == null) {
            return;
        }
        if (!this.hasPacking && member.getPackStartTime() < NulsDateUtils.getCurrentTimeSeconds() && member.getPackEndTime() > NulsDateUtils.getCurrentTimeSeconds()) {
            this.hasPacking = true;
            try {
                if (this.consensusLogger.getLogger().isDebugEnabled()) {
                    this.consensusLogger.debug("Current network time\uff1a " + NulsDateUtils.convertDate((Date)new Date(NulsDateUtils.getCurrentTimeMillis())) + " , My packaging start time: " + NulsDateUtils.convertDate((Date)new Date(member.getPackStartTime() * 1000L)) + " , My packaging end time: " + NulsDateUtils.convertDate((Date)new Date(member.getPackEndTime() * 1000L)) + " , Current round start time: " + NulsDateUtils.convertDate((Date)new Date(round.getStartTime() * 1000L)) + " , Current round end start time: " + NulsDateUtils.convertDate((Date)new Date(round.getEndTime() * 1000L)));
                }
                this.packing(chain, member, round);
            }
            catch (Exception e) {
                this.consensusLogger.error(e);
            }
            while (member.getPackEndTime() > NulsDateUtils.getCurrentTimeSeconds()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.consensusLogger.error((Exception)e);
                }
            }
            this.hasPacking = false;
        }
    }

    private void packing(Chain chain, MeetingMember self, MeetingRound round) throws Exception {
        this.waitReceiveNewestBlock(chain, self, round);
        long start = System.currentTimeMillis();
        Block block = this.doPacking(chain, self, round);
        this.consensusLogger.info("doPacking use:" + (System.currentTimeMillis() - start) + "ms\n\n");
        if (null == block) {
            this.consensusLogger.error("make a null block");
            return;
        }
        try {
            CallMethodUtils.receivePackingBlock(chain.getConfig().getChainId(), RPCUtil.encode((byte[])block.serialize()), 0L);
        }
        catch (Exception e) {
            this.consensusLogger.error(e);
        }
    }

    private void waitReceiveNewestBlock(Chain chain, MeetingMember self, MeetingRound round) {
        int waitRatio = 60;
        long timeout = chain.getConfig().getPackingInterval() * (long)waitRatio / 100L;
        long endTime = self.getPackStartTime() + timeout;
        if (NulsDateUtils.getCurrentTimeSeconds() >= endTime) {
            return;
        }
        try {
            boolean hasReceiveNewestBlock;
            while (!(hasReceiveNewestBlock = this.hasReceiveNewestBlock(chain, self, round))) {
                Thread.sleep(100L);
                if (NulsDateUtils.getCurrentTimeSeconds() < endTime) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            this.consensusLogger.error(e.getMessage());
        }
    }

    private boolean hasReceiveNewestBlock(Chain chain, MeetingMember self, MeetingRound round) {
        MeetingMember preMember;
        int myIndex = self.getPackingIndexOfRound();
        MeetingRound preRound = round;
        if (myIndex == 1) {
            preRound = round.getPreRound();
            if (preRound == null) {
                this.consensusLogger.error("PreRound is null!");
                return true;
            }
            preMember = preRound.getMember(preRound.getMemberCount());
        } else {
            preMember = round.getMember(self.getPackingIndexOfRound() - 1);
        }
        if (preMember == null) {
            return true;
        }
        BlockHeader bestBlockHeader = chain.getNewestHeader();
        BlockExtendsData blockRoundData = bestBlockHeader.getExtendsData();
        byte[] bestPackingAddress = bestBlockHeader.getPackingAddress(chain.getConfig().getChainId());
        long bestRoundIndex = blockRoundData.getRoundIndex();
        int bestPackingIndex = blockRoundData.getPackingIndexOfRound();
        byte[] prePackingAddress = preMember.getAgent().getPackingAddress();
        long preRoundIndex = preRound.getIndex();
        int prePackingIndex = preMember.getPackingIndexOfRound();
        return Arrays.equals(bestPackingAddress, prePackingAddress) && bestRoundIndex == preRoundIndex && bestPackingIndex == prePackingIndex;
    }

    private void fillProtocol(BlockExtendsData extendsData, int chainId) throws NulsException {
        if (ModuleHelper.isSupportProtocolUpdate()) {
            Map map = CallMethodUtils.getVersion(chainId);
            ProtocolVersion currentProtocolVersion = (ProtocolVersion)JSONUtils.map2pojo((Map)((Map)map.get("currentProtocolVersion")), ProtocolVersion.class);
            ProtocolVersion localProtocolVersion = (ProtocolVersion)JSONUtils.map2pojo((Map)((Map)map.get("localProtocolVersion")), ProtocolVersion.class);
            extendsData.setMainVersion(currentProtocolVersion.getVersion());
            extendsData.setBlockVersion(localProtocolVersion.getVersion());
            extendsData.setEffectiveRatio(localProtocolVersion.getEffectiveRatio());
            extendsData.setContinuousIntervalCount(localProtocolVersion.getContinuousIntervalCount());
        } else {
            extendsData.setMainVersion((short)1);
            extendsData.setBlockVersion((short)1);
            extendsData.setEffectiveRatio((byte)80);
            extendsData.setContinuousIntervalCount((short)100);
        }
    }

    private Block doPacking(Chain chain, MeetingMember self, MeetingRound round) throws Exception {
        BlockHeader bestBlock = chain.getNewestHeader();
        long packageHeight = bestBlock.getHeight() + 1L;
        BlockData bd = new BlockData();
        bd.setHeight(packageHeight);
        bd.setPreHash(bestBlock.getHash());
        bd.setTime(self.getPackEndTime());
        BlockExtendsData extendsData = new BlockExtendsData();
        extendsData.setRoundIndex(round.getIndex());
        extendsData.setConsensusMemberCount(round.getMemberCount());
        extendsData.setPackingIndexOfRound(self.getPackingIndexOfRound());
        extendsData.setRoundStartTime(round.getStartTime());
        this.fillProtocol(extendsData, chain.getConfig().getChainId());
        int chainId = chain.getConfig().getChainId();
        byte[] packingAddress = self.getAgent().getPackingAddress();
        RandomSeedStatusPo status = this.randomSeedsStorageService.getAddressStatus(chainId, packingAddress);
        byte[] seed = ConsensusConstant.EMPTY_SEED;
        if (null != status && status.getNextSeed() != null) {
            seed = status.getNextSeed();
        }
        extendsData.setSeed(seed);
        byte[] nextSeed = RandomSeedUtils.createRandomSeed();
        byte[] nextSeedHash = RandomSeedUtils.getLastDigestEightBytes(nextSeed);
        extendsData.setNextSeedHash(nextSeedHash);
        RandomSeedStatusPo po = new RandomSeedStatusPo();
        po.setAddress(packingAddress);
        po.setSeedHash(nextSeedHash);
        po.setNextSeed(nextSeed);
        po.setHeight(bd.getHeight());
        RandomSeedUtils.CACHE_SEED = po;
        String packingAddressString = AddressTool.getStringAddressByBytes((byte[])packingAddress);
        Map<String, Object> resultMap = CallMethodUtils.getPackingTxList(chain, bd.getTime(), packingAddressString);
        ArrayList<Transaction> packingTxList = new ArrayList<Transaction>();
        bestBlock = chain.getNewestHeader();
        long realPackageHeight = bestBlock.getHeight() + 1L;
        if (!bd.getPreHash().equals((Object)bestBlock.getHash()) || realPackageHeight <= packageHeight) {
            bd.setHeight(realPackageHeight);
            bd.setPreHash(bestBlock.getHash());
            bestBlock = chain.getNewestHeader();
        }
        BlockExtendsData bestExtendsData = bestBlock.getExtendsData();
        boolean stateRootIsNull = false;
        if (resultMap == null) {
            extendsData.setStateRoot(bestExtendsData.getStateRoot());
            stateRootIsNull = true;
        } else {
            long txPackageHeight = Long.parseLong(resultMap.get("packageHeight").toString());
            String stateRoot = (String)resultMap.get("stateRoot");
            if (StringUtils.isBlank((String)stateRoot)) {
                extendsData.setStateRoot(bestExtendsData.getStateRoot());
                stateRootIsNull = true;
            } else {
                extendsData.setStateRoot(RPCUtil.decode((String)stateRoot));
            }
            if (realPackageHeight >= txPackageHeight) {
                List txHexList = (List)resultMap.get("list");
                for (String txHex : txHexList) {
                    Transaction tx = new Transaction();
                    tx.parse(RPCUtil.decode((String)txHex), 0);
                    packingTxList.add(tx);
                }
            }
        }
        bd.setExtendsData(extendsData);
        ConsensusManager consensusManager = (ConsensusManager)SpringLiteContext.getBean(ConsensusManager.class);
        consensusManager.addConsensusTx(chain, bestBlock, packingTxList, self, round, extendsData);
        bd.setTxList(packingTxList);
        Block newBlock = consensusManager.createBlock(chain, bd, packingAddress, packingAddressString);
        bestBlock = chain.getNewestHeader();
        if (!newBlock.getHeader().getPreHash().equals((Object)bestBlock.getHash())) {
            packingTxList.clear();
            consensusManager.addConsensusTx(chain, bestBlock, packingTxList, self, round, extendsData);
            bd.setTxList(packingTxList);
            bd.setPreHash(bestBlock.getHash());
            bd.setHeight(bestBlock.getHeight() + 1L);
            newBlock = consensusManager.createBlock(chain, bd, packingAddress, packingAddressString);
            if (stateRootIsNull) {
                bestExtendsData = bestBlock.getExtendsData();
                extendsData.setStateRoot(bestExtendsData.getStateRoot());
                newBlock.getHeader().setExtend(extendsData.serialize());
            }
        }
        this.consensusLogger.info("make block height:" + newBlock.getHeader().getHeight() + ",txCount: " + newBlock.getTxs().size() + " , block size: " + newBlock.size() + " , time:" + NulsDateUtils.convertDate((Date)new Date(newBlock.getHeader().getTime() * 1000L)) + ",packEndTime:" + NulsDateUtils.convertDate((Date)new Date(self.getPackEndTime() * 1000L)) + ",hash:" + newBlock.getHeader().getHash().toHex() + ",preHash:" + newBlock.getHeader().getPreHash().toHex());
        return newBlock;
    }
}

