/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.validator;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.round.RoundValidResult;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.RedPunishData;
import io.nuls.consensus.model.bo.tx.txdata.YellowPunishData;
import io.nuls.consensus.utils.compare.CoinFromComparator;
import io.nuls.consensus.utils.compare.CoinToComparator;
import io.nuls.consensus.utils.enumeration.PunishReasonEnum;
import io.nuls.consensus.utils.manager.CoinDataManager;
import io.nuls.consensus.utils.manager.ConsensusManager;
import io.nuls.consensus.utils.manager.PunishManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.DoubleUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

@Component
public class BlockValidator {
    @Autowired
    private RoundManager roundManager;
    @Autowired
    private PunishManager punishManager;
    @Autowired
    private ConsensusManager consensusManager;
    @Autowired
    private CoinDataManager coinDataManager;

    public void validate(boolean isDownload, Chain chain, Block block) throws NulsException, IOException {
        RoundValidResult roundValidResult;
        BlockHeader blockHeader = block.getHeader();
        if (!blockHeader.getMerkleHash().equals((Object)NulsHash.calcMerkleHash((List)block.getTxHashList()))) {
            throw new NulsException(ConsensusErrorCode.MERKEL_HASH_ERROR);
        }
        if (blockHeader.getBlockSignature().verifySignature(blockHeader.getHash()).isFailed()) {
            chain.getLogger().error("Block Header Verification Error!");
            throw new NulsException(ConsensusErrorCode.SIGNATURE_ERROR);
        }
        if (block.getHeader().getTime() - 10L > NulsDateUtils.getCurrentTimeSeconds()) {
            chain.getLogger().error("There is a big difference between the block time and the actual time!");
            throw new NulsException(ConsensusErrorCode.ERROR_UNLOCK_TIME);
        }
        String blockHeaderHash = blockHeader.getHash().toHex();
        try {
            roundValidResult = this.roundValidate(isDownload, chain, blockHeader, blockHeaderHash);
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
        MeetingRound currentRound = roundValidResult.getRound();
        BlockExtendsData extendsData = blockHeader.getExtendsData();
        MeetingMember member = currentRound.getMember(extendsData.getPackingIndexOfRound());
        boolean validResult = this.punishValidate(block, currentRound, member, chain, blockHeaderHash);
        if (!validResult) {
            if (roundValidResult.isValidResult()) {
                this.roundManager.rollBackRound(chain, currentRound.getIndex());
            }
            throw new NulsException(ConsensusErrorCode.BLOCK_PUNISH_VALID_ERROR);
        }
        validResult = this.coinBaseValidate(block, currentRound, member, chain, blockHeaderHash);
        if (!validResult) {
            if (roundValidResult.isValidResult()) {
                this.roundManager.rollBackRound(chain, currentRound.getIndex());
            }
            throw new NulsException(ConsensusErrorCode.BLOCK_COINBASE_VALID_ERROR);
        }
    }

    private RoundValidResult roundValidate(boolean isDownload, Chain chain, BlockHeader blockHeader, String blockHeaderHash) throws Exception {
        boolean isBeforeBlock;
        BlockExtendsData extendsData = blockHeader.getExtendsData();
        BlockHeader bestBlockHeader = chain.getNewestHeader();
        BlockExtendsData bestExtendsData = bestBlockHeader.getExtendsData();
        RoundValidResult roundValidResult = new RoundValidResult();
        boolean bl = isBeforeBlock = extendsData.getRoundIndex() < bestExtendsData.getRoundIndex() || extendsData.getRoundIndex() == bestExtendsData.getRoundIndex() && extendsData.getPackingIndexOfRound() <= bestExtendsData.getPackingIndexOfRound();
        if (isBeforeBlock) {
            chain.getLogger().error("new block roundData error, block height : " + blockHeader.getHeight() + " , hash :" + blockHeaderHash);
            throw new NulsException(ConsensusErrorCode.BLOCK_ROUND_VALIDATE_ERROR);
        }
        if (chain.getNewestHeader().getHeight() == 0L) {
            chain.getRoundList().clear();
        }
        MeetingRound currentRound = this.roundManager.getCurrentRound(chain);
        boolean hasChangeRound = false;
        if (currentRound == null || extendsData.getRoundIndex() < currentRound.getIndex()) {
            MeetingRound round = this.roundManager.getRoundByIndex(chain, extendsData.getRoundIndex());
            currentRound = round != null ? round : this.roundManager.getRound(chain, extendsData, false);
            if (chain.getRoundList().isEmpty()) {
                hasChangeRound = true;
            }
        } else if (extendsData.getRoundIndex() > currentRound.getIndex()) {
            if (extendsData.getRoundStartTime() < currentRound.getEndTime()) {
                chain.getLogger().error("block height " + blockHeader.getHeight() + " round index and start time not match! hash :" + blockHeaderHash);
                throw new NulsException(ConsensusErrorCode.BLOCK_ROUND_VALIDATE_ERROR);
            }
            if (extendsData.getRoundStartTime() > NulsDateUtils.getCurrentTimeSeconds() + chain.getConfig().getPackingInterval()) {
                chain.getLogger().error("block height " + blockHeader.getHeight() + " round startTime is error, greater than current time! hash :" + blockHeaderHash);
                throw new NulsException(ConsensusErrorCode.BLOCK_ROUND_VALIDATE_ERROR);
            }
            if (extendsData.getRoundStartTime() + (long)(extendsData.getPackingIndexOfRound() - 1) * chain.getConfig().getPackingInterval() > NulsDateUtils.getCurrentTimeSeconds() + chain.getConfig().getPackingInterval()) {
                chain.getLogger().error("block height " + blockHeader.getHeight() + " is the block of the future and received in advance! hash :" + blockHeaderHash);
                throw new NulsException(ConsensusErrorCode.BLOCK_ROUND_VALIDATE_ERROR);
            }
            MeetingRound tempRound = this.roundManager.getRound(chain, extendsData, !isDownload);
            if (tempRound.getIndex() > currentRound.getIndex()) {
                tempRound.setPreRound(currentRound);
                hasChangeRound = true;
            }
            currentRound = tempRound;
        }
        if (extendsData.getRoundIndex() != currentRound.getIndex() || extendsData.getRoundStartTime() != currentRound.getStartTime()) {
            chain.getLogger().error("block height " + blockHeader.getHeight() + " round startTime is error! hash :" + blockHeaderHash);
            throw new NulsException(ConsensusErrorCode.BLOCK_ROUND_VALIDATE_ERROR);
        }
        if (extendsData.getConsensusMemberCount() != currentRound.getMemberCount()) {
            chain.getLogger().error("block height " + blockHeader.getHeight() + " packager count is error! hash :" + blockHeaderHash);
            throw new NulsException(ConsensusErrorCode.BLOCK_ROUND_VALIDATE_ERROR);
        }
        MeetingMember member = currentRound.getMember(extendsData.getPackingIndexOfRound());
        if (!Arrays.equals(member.getAgent().getPackingAddress(), blockHeader.getPackingAddress(chain.getConfig().getChainId()))) {
            chain.getLogger().error("block height " + blockHeader.getHeight() + " packager error! hash :" + blockHeaderHash);
            throw new NulsException(ConsensusErrorCode.BLOCK_ROUND_VALIDATE_ERROR);
        }
        if (member.getPackEndTime() != blockHeader.getTime()) {
            chain.getLogger().error("block height " + blockHeader.getHeight() + " time error! hash :" + blockHeaderHash);
            throw new NulsException(ConsensusErrorCode.BLOCK_ROUND_VALIDATE_ERROR);
        }
        if (hasChangeRound) {
            this.roundManager.addRound(chain, currentRound);
            roundValidResult.setValidResult(true);
        }
        roundValidResult.setRound(currentRound);
        return roundValidResult;
    }

    private boolean punishValidate(Block block, MeetingRound currentRound, MeetingMember member, Chain chain, String blockHeaderHash) throws NulsException {
        List txs = block.getTxs();
        ArrayList<Transaction> redPunishTxList = new ArrayList<Transaction>();
        Transaction yellowPunishTx = null;
        for (int index = 1; index < txs.size(); ++index) {
            Transaction tx = (Transaction)txs.get(index);
            if (tx.getType() == 1) {
                chain.getLogger().error("Coinbase transaction more than one! height: " + block.getHeader().getHeight() + " , hash : " + blockHeaderHash);
                return false;
            }
            if (tx.getType() == 7) {
                if (yellowPunishTx == null) {
                    yellowPunishTx = tx;
                    continue;
                }
                chain.getLogger().error("Yellow punish transaction more than one! height: " + block.getHeader().getHeight() + " , hash : " + blockHeaderHash);
                return false;
            }
            if (tx.getType() != 8) continue;
            redPunishTxList.add(tx);
        }
        try {
            boolean isMatch;
            Transaction newYellowPunishTX = this.punishManager.createYellowPunishTx(chain, chain.getNewestHeader(), member, currentRound);
            boolean bl = isMatch = yellowPunishTx == null && newYellowPunishTX == null || yellowPunishTx != null && newYellowPunishTX != null;
            if (!isMatch) {
                chain.getLogger().error("The yellow punish tx is wrong! height: " + block.getHeader().getHeight() + " , hash : " + blockHeaderHash);
                return false;
            }
            if (yellowPunishTx != null && !yellowPunishTx.getHash().equals((Object)newYellowPunishTX.getHash())) {
                chain.getLogger().error("The yellow punish tx's hash is wrong! height: " + block.getHeader().getHeight() + " , hash : " + blockHeaderHash);
                return false;
            }
        }
        catch (Exception e) {
            chain.getLogger().error("The tx's wrong! height: " + block.getHeader().getHeight() + " , hash : " + blockHeaderHash, e);
            return false;
        }
        if (!redPunishTxList.isEmpty()) {
            HashSet<String> punishAddress = new HashSet<String>();
            if (null != yellowPunishTx) {
                YellowPunishData yellowPunishData = new YellowPunishData();
                yellowPunishData.parse(yellowPunishTx.getTxData(), 0);
                List<byte[]> addressList = yellowPunishData.getAddressList();
                for (byte[] address : addressList) {
                    MeetingMember item = currentRound.getMemberByAgentAddress(address);
                    if (null == item) {
                        item = currentRound.getPreRound().getMemberByAgentAddress(address);
                    }
                    if (DoubleUtils.compare((double)item.getAgent().getRealCreditVal(), (double)-1.0) > 0) continue;
                    punishAddress.add(AddressTool.getStringAddressByBytes((byte[])item.getAgent().getAgentAddress()));
                }
            }
            int countOfTooMuchYP = 0;
            for (Transaction redTx : redPunishTxList) {
                boolean result;
                RedPunishData data = new RedPunishData();
                data.parse(redTx.getTxData(), 0);
                if (data.getReasonCode() == PunishReasonEnum.TOO_MUCH_YELLOW_PUNISH.getCode()) {
                    ++countOfTooMuchYP;
                    if (!punishAddress.contains(AddressTool.getStringAddressByBytes((byte[])data.getAddress()))) {
                        chain.getLogger().error("There is a wrong red punish tx!" + blockHeaderHash);
                        return false;
                    }
                    if (redTx.getTime() != block.getHeader().getTime()) {
                        chain.getLogger().error("red punish CoinData & TX time is wrong! " + blockHeaderHash);
                        return false;
                    }
                }
                if (result = this.verifyRedPunish(chain, redTx)) continue;
                return false;
            }
            if (countOfTooMuchYP != punishAddress.size()) {
                chain.getLogger().error("There is a wrong red punish tx!" + blockHeaderHash);
                return false;
            }
        }
        return true;
    }

    private boolean verifyRedPunish(Chain chain, Transaction tx) throws NulsException {
        RedPunishData punishData = new RedPunishData();
        punishData.parse(tx.getTxData(), 0);
        if (punishData.getReasonCode() == PunishReasonEnum.BIFURCATION.getCode()) {
            NulsByteBuffer byteBuffer = new NulsByteBuffer(punishData.getEvidence());
            long[] roundIndex = new long[3];
            for (int i = 0; i < 3 && !byteBuffer.isFinished(); ++i) {
                BlockHeader header1 = null;
                BlockHeader header2 = null;
                try {
                    header1 = (BlockHeader)byteBuffer.readNulsData((BaseNulsData)new BlockHeader());
                    header2 = (BlockHeader)byteBuffer.readNulsData((BaseNulsData)new BlockHeader());
                }
                catch (NulsException e) {
                    chain.getLogger().error(e.getMessage());
                }
                if (null == header1 || null == header2) {
                    throw new NulsException(ConsensusErrorCode.DATA_NOT_EXIST);
                }
                if (header1.getHeight() != header2.getHeight()) {
                    throw new NulsException(ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
                }
                if (!Arrays.equals(header1.getBlockSignature().getPublicKey(), header2.getBlockSignature().getPublicKey())) {
                    throw new NulsException(ConsensusErrorCode.BLOCK_SIGNATURE_ERROR);
                }
                BlockExtendsData blockExtendsData = header1.getExtendsData();
                roundIndex[i] = blockExtendsData.getRoundIndex();
            }
            if (roundIndex[2] - roundIndex[0] > 100L) {
                throw new NulsException(ConsensusErrorCode.BLOCK_RED_PUNISH_ERROR);
            }
        } else if (punishData.getReasonCode() != PunishReasonEnum.TOO_MUCH_YELLOW_PUNISH.getCode()) {
            throw new NulsException(ConsensusErrorCode.BLOCK_PUNISH_VALID_ERROR);
        }
        if (!this.coinDataValidate(chain, tx)) {
            throw new NulsException(ConsensusErrorCode.COIN_DATA_VALID_ERROR);
        }
        return true;
    }

    private boolean coinBaseValidate(Block block, MeetingRound currentRound, MeetingMember member, Chain chain, String blockHeaderHash) throws NulsException, IOException {
        Transaction tx = (Transaction)block.getTxs().get(0);
        if (tx.getType() != 1) {
            chain.getLogger().error("CoinBase transaction order wrong! height: " + block.getHeader().getHeight() + " , hash : " + blockHeaderHash);
            return false;
        }
        Transaction coinBaseTransaction = this.consensusManager.createCoinBaseTx(chain, member, block.getTxs(), currentRound, 0L);
        if (null == coinBaseTransaction) {
            chain.getLogger().error("the coin base tx is wrong! height: " + block.getHeader().getHeight() + " , hash : " + blockHeaderHash);
            return false;
        }
        if (!tx.getHash().equals((Object)coinBaseTransaction.getHash())) {
            CoinFromComparator fromComparator = new CoinFromComparator();
            CoinToComparator toComparator = new CoinToComparator();
            CoinData coinBaseCoinData = coinBaseTransaction.getCoinDataInstance();
            coinBaseCoinData.getFrom().sort(fromComparator);
            coinBaseCoinData.getTo().sort(toComparator);
            coinBaseTransaction.setCoinData(coinBaseCoinData.serialize());
            Transaction originTransaction = new Transaction();
            originTransaction.parse(tx.serialize(), 0);
            CoinData originCoinData = originTransaction.getCoinDataInstance();
            originCoinData.getFrom().sort(fromComparator);
            originCoinData.getTo().sort(toComparator);
            originTransaction.setCoinData(originCoinData.serialize());
            if (!originTransaction.getHash().equals((Object)coinBaseTransaction.getHash())) {
                chain.getLogger().error("the coin base tx is wrong! height: " + block.getHeader().getHeight() + " , hash : " + blockHeaderHash);
                return false;
            }
        }
        return true;
    }

    private boolean coinDataValidate(Chain chain, Transaction tx) throws NulsException {
        Agent punishAgent = null;
        RedPunishData punishData = new RedPunishData();
        punishData.parse(tx.getTxData(), 0);
        for (Agent agent : chain.getAgentList()) {
            if (agent.getDelHeight() > 0L && (tx.getBlockHeight() <= 0L || agent.getDelHeight() < tx.getBlockHeight()) || !Arrays.equals(punishData.getAddress(), agent.getAgentAddress())) continue;
            punishAgent = agent;
            break;
        }
        if (null == punishAgent) {
            Log.info((String)ConsensusErrorCode.AGENT_NOT_EXIST.getMsg());
            return false;
        }
        CoinData coinData = this.coinDataManager.getStopAgentCoinData(chain, punishAgent, tx.getTime() + chain.getConfig().getRedPublishLockTime());
        try {
            CoinFromComparator fromComparator = new CoinFromComparator();
            CoinToComparator toComparator = new CoinToComparator();
            coinData.getFrom().sort(fromComparator);
            coinData.getTo().sort(toComparator);
            CoinData txCoinData = new CoinData();
            txCoinData.parse(tx.getCoinData(), 0);
            txCoinData.getFrom().sort(fromComparator);
            txCoinData.getTo().sort(toComparator);
            if (!Arrays.equals(coinData.serialize(), txCoinData.serialize())) {
                chain.getLogger().error("++++++++++ RedPunish verification does not pass, redPunish type:{}, - height:{}, - redPunish tx timestamp:{}", new Object[]{punishData.getReasonCode(), tx.getBlockHeight(), tx.getTime()});
                return false;
            }
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return false;
        }
        return true;
    }
}

