/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.callable;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.helper.ContractNewTxHandler;
import io.nuls.contract.helper.ContractTransferHandler;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.BatchInfoV8;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.tx.ContractTransferTransaction;
import io.nuls.contract.model.txdata.CallContractData;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.model.txdata.ContractTransferData;
import io.nuls.contract.service.ContractExecutor;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramInternalCreate;
import io.nuls.core.basic.Result;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class ContractTxCallableV22 {
    private ContractExecutor contractExecutor;
    private ContractHelper contractHelper;
    private ContractNewTxHandler contractNewTxHandler;
    private ContractTransferHandler contractTransferHandler;
    private ContractTempBalanceManager tempBalanceManager;
    private ProgramExecutor executor;
    private String contract;
    private ContractWrapperTransaction tx;
    private long number;
    private String preStateRoot;
    private int chainId;
    private int blockType;
    private long blockTime;
    private BatchInfoV8 batchInfo;

    public ContractTxCallableV22(int chainId, int blockType, long blockTime, ProgramExecutor executor, String contract, ContractWrapperTransaction tx, long number, String preStateRoot) {
        this.chainId = chainId;
        this.blockType = blockType;
        this.blockTime = blockTime;
        this.contractExecutor = (ContractExecutor)SpringLiteContext.getBean(ContractExecutor.class);
        this.contractHelper = (ContractHelper)SpringLiteContext.getBean(ContractHelper.class);
        this.contractNewTxHandler = (ContractNewTxHandler)SpringLiteContext.getBean(ContractNewTxHandler.class);
        this.contractTransferHandler = (ContractTransferHandler)SpringLiteContext.getBean(ContractTransferHandler.class);
        this.tempBalanceManager = this.contractHelper.getBatchInfoTempBalanceManagerV8(chainId);
        this.executor = executor;
        this.contract = contract;
        this.tx = tx;
        this.number = number;
        this.preStateRoot = preStateRoot;
    }

    public ContractResult call() throws Exception {
        ChainManager.chainHandle(this.chainId, this.blockType);
        this.batchInfo = this.contractHelper.getChain(this.chainId).getBatchInfoV8();
        String hash = this.tx.getHash().toHex();
        long start = System.currentTimeMillis();
        ContractResult contractResult = null;
        ContractData contractData = this.tx.getContractData();
        int type = this.tx.getType();
        if (type != 17 && !ContractUtil.checkPrice(contractData.getPrice())) {
            contractResult = this.contractHelper.makeFailedContractResult(this.chainId, this.tx, null, "The gas price is error.");
        } else {
            switch (type) {
                case 15: {
                    contractResult = this.contractExecutor.create(this.executor, contractData, this.number, this.preStateRoot, ContractUtil.extractPublicKey(this.tx));
                    this.checkCreateResult(this.tx, contractResult);
                    break;
                }
                case 10: 
                case 16: {
                    if (this.batchInfo.getCreateSet().contains(this.contract)) {
                        contractResult = this.contractHelper.makeFailedContractResult(this.chainId, this.tx, null, "contract lock or not exist.");
                        break;
                    }
                    if (this.batchInfo.getDeleteSet().contains(this.contract)) {
                        contractResult = this.contractHelper.makeFailedContractResult(this.chainId, this.tx, null, "contract has been terminated.");
                        break;
                    }
                    this.contractHelper.extractAssetInfoFromCallTransaction((CallContractData)contractData, this.tx);
                    contractResult = this.contractExecutor.call(this.executor, contractData, this.number, this.preStateRoot, ContractUtil.extractPublicKey(this.tx));
                    this.checkCallResult(this.tx, contractResult);
                    break;
                }
                case 17: {
                    contractResult = this.contractExecutor.delete(this.executor, contractData, this.number, this.preStateRoot);
                    this.checkDeleteResult(this.tx, contractResult);
                    break;
                }
            }
        }
        if (contractResult != null && !contractResult.isSuccess()) {
            Log.error("Failed TxType [{}] Execute ContractResult is {}", this.tx.getType(), contractResult.toString());
        }
        Log.info("[Per Contract Execution Cost Time] TxType is {}, TxHash is {}, Cost Time is {}", this.tx.getType(), hash, System.currentTimeMillis() - start);
        return contractResult;
    }

    private void checkCreateResult(ContractWrapperTransaction tx, ContractResult contractResult) {
        ContractUtil.makeContractResult(tx, contractResult);
        this.batchInfo.getCreateSet().add(this.contract);
        if (contractResult.isSuccess()) {
            Result checkResult = this.contractHelper.validateNrc20Contract(this.chainId, (ProgramExecutor)contractResult.getTxTrack(), tx, contractResult);
            if (checkResult.isFailed()) {
                Log.error("check validateNrc20Contract Result is {}", checkResult.toString());
            }
            if (checkResult.isSuccess()) {
                this.commitContract(contractResult);
            }
        }
    }

    private void checkCallResult(ContractWrapperTransaction tx, ContractResult contractResult) throws IOException, NulsException {
        ContractUtil.makeContractResult(tx, contractResult);
        this.dealCallResult(tx, contractResult, this.chainId);
    }

    private void dealCallResult(ContractWrapperTransaction tx, ContractResult contractResult, int chainId) throws IOException, NulsException {
        if (contractResult.isSuccess()) {
            boolean isSuccess = true;
            List<ProgramInternalCreate> internalCreates = contractResult.getProgramInternalCreates();
            if (internalCreates != null && !internalCreates.isEmpty()) {
                for (ProgramInternalCreate internalCreate : internalCreates) {
                    Result checkResult = this.contractHelper.validateNrc20ContractByInternalCreate(chainId, (ProgramExecutor)contractResult.getTxTrack(), internalCreate, contractResult);
                    if (checkResult.isFailed()) {
                        Log.error("ProgramInternalCreate check validateNrc20Contract Result is {}", checkResult.toString());
                        isSuccess = false;
                        break;
                    }
                    this.batchInfo.getCreateSet().add(AddressTool.getStringAddressByBytes((byte[])internalCreate.getContractAddress()));
                }
            }
            if (isSuccess) {
                isSuccess = this.contractNewTxHandler.handleContractNewTx(chainId, this.blockTime, tx, contractResult, this.tempBalanceManager);
            }
            if (!isSuccess) {
                this.handleFailedContract(contractResult);
            }
        } else {
            this.handleFailedContract(contractResult);
        }
        if (contractResult.isSuccess()) {
            this.commitContract(contractResult);
        }
    }

    private void handleFailedContract(ContractResult contractResult) throws IOException, NulsException {
        ContractWrapperTransaction orginTx = contractResult.getTx();
        ContractData contractData = orginTx.getContractData();
        NulsHash orginTxHash = orginTx.getHash();
        BigInteger value = contractData.getValue();
        byte[] contractAddress = contractData.getContractAddress();
        CoinData orginTxCoinData = orginTx.getCoinDataInstance();
        List fromList = orginTxCoinData.getFrom();
        for (CoinFrom from : fromList) {
            int assetChainId = from.getAssetsChainId();
            int assetId = from.getAssetsId();
            if (ContractContext.LOCAL_CHAIN_ID != assetChainId || ContractContext.LOCAL_MAIN_ASSET_ID != assetId) {
                ContractTransferTransaction tx = this.generateContractTransferTransaction(orginTxHash, contractAddress, from.getAddress(), from.getAmount(), assetChainId, assetId);
                contractResult.getContractTransferList().add(tx);
                continue;
            }
            if (from.getAmount().compareTo(value) < 0) continue;
            orginTx.setValueSender(from.getAddress());
        }
        if (value.compareTo(BigInteger.ZERO) > 0) {
            byte[] sender = orginTx.getValueSender();
            if (sender == null) {
                sender = contractData.getSender();
            }
            ContractTransferTransaction tx = this.generateContractTransferTransaction(orginTxHash, contractAddress, sender, value, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
            contractResult.getContractTransferList().add(tx);
        }
        contractResult.setMergedTransferList(this.contractTransferHandler.contractTransfer2mergedTransfer(orginTx, contractResult.getContractTransferList()));
        contractResult.setMergerdMultyAssetTransferList(this.contractTransferHandler.contractMultyAssetTransfer2mergedTransfer(orginTx, contractResult.getContractTransferList()));
    }

    private ContractTransferTransaction generateContractTransferTransaction(NulsHash orginTxHash, byte[] contractAddress, byte[] recipient, BigInteger value, int assetChainId, int assetId) throws IOException {
        ContractTransferData txData = new ContractTransferData(orginTxHash, contractAddress);
        CoinData coinData = new CoinData();
        ContractBalance balance = (ContractBalance)this.tempBalanceManager.getBalance(contractAddress, assetChainId, assetId).getData();
        byte[] nonceBytes = RPCUtil.decode((String)balance.getNonce());
        CoinFrom coinFrom = new CoinFrom(contractAddress, assetChainId, assetId, value, nonceBytes, 0);
        coinData.getFrom().add(coinFrom);
        CoinTo coinTo = new CoinTo(recipient, assetChainId, assetId, value, 0L);
        coinData.getTo().add(coinTo);
        ContractTransferTransaction tx = new ContractTransferTransaction();
        tx.setCoinDataObj(coinData);
        tx.setTxDataObj(txData);
        tx.setTime(this.blockTime);
        tx.serializeData();
        NulsHash hash = NulsHash.calcHash((byte[])tx.serializeForHash());
        byte[] hashBytes = hash.getBytes();
        byte[] currentNonceBytes = Arrays.copyOfRange(hashBytes, hashBytes.length - 8, hashBytes.length);
        balance.setNonce(RPCUtil.encode((byte[])currentNonceBytes));
        tx.setHash(hash);
        return tx;
    }

    private void commitContract(ContractResult contractResult) {
        if (!contractResult.isSuccess()) {
            return;
        }
        Object txTrackObj = contractResult.getTxTrack();
        if (txTrackObj != null && txTrackObj instanceof ProgramExecutor) {
            ProgramExecutor txTrack = (ProgramExecutor)txTrackObj;
            txTrack.commit();
        }
    }

    private boolean checkDeleteResult(ContractWrapperTransaction tx, ContractResult contractResult) {
        this.batchInfo.getDeleteSet().add(this.contract);
        ContractUtil.makeContractResult(tx, contractResult);
        boolean result = false;
        if (contractResult.isSuccess()) {
            result = true;
            this.commitContract(contractResult);
        }
        return result;
    }
}

