/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.nuls.base.basic.AddressTool;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.ChainContext;
import io.nuls.contract.enums.TokenTypeStatus;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.core.basic.Result;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class ContractContext {
    public static Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    public static String DATA_PATH;
    public static int MAIN_CHAIN_ID;
    public static int MAIN_ASSETS_ID;
    public static int LOCAL_CHAIN_ID;
    public static int LOCAL_MAIN_ASSET_ID;
    public static byte[] CROSS_CHAIN_SYSTEM_CONTRACT;
    public static short UPDATE_VERSION_V240;
    public static short UPDATE_VERSION_V250;
    public static short UPDATE_VERSION_CONTRACT_ASSET;
    public static short UPDATE_VERSION_CONTRACT_BALANCE;
    public static short UPDATE_VERSION_ACCOUNT_TRANSFER_ON_CONTRACT_CALL;
    public static short PROTOCOL_14;
    public static short PROTOCOL_15;
    public static short PROTOCOL_16;
    public static short PROTOCOL_17;
    public static short PROTOCOL_19;
    public static short PROTOCOL_20;
    public static short PROTOCOL_21;
    public static short PROTOCOL_22;
    private static final LoadingCache<String, ContractAddressInfoPo> CONTRACT_INFO_CACHE;
    public static Set<String> FEE_ASSETS_SET;
    public static ContractHelper contractHelper;

    public static void loadContractAddressInfo(ContractAddressInfoPo info) {
        if (info != null) {
            CONTRACT_INFO_CACHE.put((Object)AddressTool.getStringAddressByBytes((byte[])info.getContractAddress()), (Object)info);
        }
    }

    public static int getTokenType(String contract) {
        ContractAddressInfoPo contractAddressInfo = ContractContext.getContractAddressInfo(contract);
        if (contractAddressInfo == null) {
            return TokenTypeStatus.NOT_TOKEN.status();
        }
        return contractAddressInfo.getTokenType();
    }

    public static ContractAddressInfoPo getContractAddressInfo(String contract) {
        try {
            return (ContractAddressInfoPo)CONTRACT_INFO_CACHE.get((Object)contract);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static void setContractHelper(ContractHelper contractHelper) {
        if (contractHelper == null) {
            return;
        }
        ContractContext.contractHelper = contractHelper;
    }

    public static long bestHeight() {
        ChainContext context = ContextManager.getContext(LOCAL_CHAIN_ID);
        if (context == null) {
            return 0L;
        }
        return context.getLatestHeight();
    }

    static {
        MAIN_CHAIN_ID = 1;
        MAIN_ASSETS_ID = 1;
        LOCAL_CHAIN_ID = 1;
        LOCAL_MAIN_ASSET_ID = 1;
        UPDATE_VERSION_V240 = (short)4;
        UPDATE_VERSION_V250 = (short)5;
        UPDATE_VERSION_CONTRACT_ASSET = (short)8;
        UPDATE_VERSION_CONTRACT_BALANCE = (short)9;
        UPDATE_VERSION_ACCOUNT_TRANSFER_ON_CONTRACT_CALL = (short)13;
        PROTOCOL_14 = (short)14;
        PROTOCOL_15 = (short)15;
        PROTOCOL_16 = (short)16;
        PROTOCOL_17 = (short)17;
        PROTOCOL_19 = (short)19;
        PROTOCOL_20 = (short)20;
        PROTOCOL_21 = (short)21;
        PROTOCOL_22 = (short)22;
        FEE_ASSETS_SET = new HashSet<String>();
        CONTRACT_INFO_CACHE = CacheBuilder.newBuilder().initialCapacity(200).maximumSize(200L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ContractAddressInfoPo>(){

            public ContractAddressInfoPo load(String contract) {
                Result<ContractAddressInfoPo> contractAddressInfoResult = contractHelper.getContractAddressInfo(LOCAL_CHAIN_ID, AddressTool.getAddress((String)contract));
                ContractAddressInfoPo po = (ContractAddressInfoPo)contractAddressInfoResult.getData();
                return po;
            }
        });
    }
}

