/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.manager;

import io.nuls.common.CommonContext;
import io.nuls.common.ConfigBean;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.manager.ContractTxCreateUnconfirmedManager;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.util.Log;
import io.nuls.contract.util.LogUtil;
import io.nuls.contract.util.VMContext;
import io.nuls.contract.vm.program.impl.ProgramExecutorImpl;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class ChainManager {
    @Autowired
    private VMContext vmContext;
    @Autowired
    private NulsCoresConfig contractConfig;
    private Map<Integer, Chain> chainMap = new ConcurrentHashMap<Integer, Chain>();

    public void initChain() throws Exception {
        Map<Integer, ConfigBean> configMap = this.configChain();
        if (configMap == null || configMap.size() == 0) {
            return;
        }
        for (Map.Entry<Integer, ConfigBean> entry : configMap.entrySet()) {
            Chain chain = new Chain();
            int chainId = entry.getKey();
            chain.setConfig(entry.getValue());
            this.initTable(chain);
            this.initContractExecutor(chain);
            this.initContractTxCreateUnconfirmedManager(chain);
            this.initContractChainLog(chainId);
            this.chainMap.put(chainId, chain);
        }
    }

    private void initContractTxCreateUnconfirmedManager(Chain chain) {
        ContractTxCreateUnconfirmedManager manager = ContractTxCreateUnconfirmedManager.newInstance(chain.getChainId());
        chain.setContractTxCreateUnconfirmedManager(manager);
    }

    private void initContractExecutor(Chain chain) {
        ProgramExecutorImpl programExecutor = new ProgramExecutorImpl(this.vmContext, chain);
        chain.setProgramExecutor(programExecutor);
    }

    private void initContractChainLog(int chainId) {
        LogUtil.configChainLog(chainId, "smart-contract");
    }

    public void stopChain(int chainId) {
    }

    private Map<Integer, ConfigBean> configChain() {
        try {
            Map<Integer, ConfigBean> configMap = CommonContext.CONFIG_BEAN_MAP;
            if (configMap == null || configMap.size() == 0) {
                NulsCoresConfig configBean = this.contractConfig;
                if (configBean == null) {
                    return null;
                }
                configMap.put(((ConfigBean)configBean).getChainId(), configBean);
            }
            return configMap;
        }
        catch (Exception e) {
            Log.error(e);
            return null;
        }
    }

    private void initTable(Chain chain) {
        block2: {
            int chainId = chain.getChainId();
            try {
                RocksDBService.createTable((String)("contract_address_" + chainId));
                RocksDBService.createTable((String)("contract_execute_result_" + chainId));
                RocksDBService.createTable((String)("contract_offline_tx_hash_list_" + chainId));
            }
            catch (Exception e) {
                if ("DB table exists".equals(e.getMessage())) break block2;
                Log.error(e.getMessage());
            }
        }
    }

    public static void chainHandle(int chainId, int blockType) {
        Log.currentThreadChainId(chainId);
        Chain.putCurrentThreadBlockType(blockType);
    }

    public static void chainHandle(int chainId) {
        Log.currentThreadChainId(chainId);
    }

    public Map<Integer, Chain> getChainMap() {
        return this.chainMap;
    }

    public void setChainMap(Map<Integer, Chain> chainMap) {
        this.chainMap = chainMap;
    }
}

