/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.manager;

import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.enums.CmdRegisterMode;
import io.nuls.contract.enums.CmdRegisterReturnType;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.manager.interfaces.RequestAndResponseInterface;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.CmdRegister;
import io.nuls.contract.model.dto.CmdRegisterDto;
import io.nuls.contract.model.dto.ModuleCmdRegisterDto;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.List;
import java.util.Map;

@Component
public class CmdRegisterManager
implements InitializingBean {
    @Autowired
    private ChainManager chainManager;
    private RequestAndResponseInterface requestAndResponseInterface;

    public void afterPropertiesSet() throws NulsException {
        this.requestAndResponseInterface = new RequestAndResponseInterface(){

            @Override
            public Response requestAndResponse(String moduleCode, String cmdName, Map argsMap) throws Exception {
                return ResponseMessageProcessor.requestAndResponse((String)moduleCode, (String)cmdName, (Map)argsMap);
            }
        };
    }

    public Result registerCmd(ModuleCmdRegisterDto moduleCmdRegisterDto) {
        int chainId = moduleCmdRegisterDto.getChainId();
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            Log.error("chain not found, chainId is {}", chainId);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.DATA_NOT_FOUND);
        }
        String moduleCode = moduleCmdRegisterDto.getModuleCode();
        List<CmdRegisterDto> cmdRegisterList = moduleCmdRegisterDto.getCmdRegisterList();
        for (CmdRegisterDto dto : cmdRegisterList) {
            Result result = this.registerCmd(chain, moduleCode, dto.getCmdName(), dto.getCmdRegisterMode(), dto.getArgNames(), dto.getCmdRegisterReturnType());
            if (!result.isFailed()) continue;
            return result;
        }
        return ContractUtil.getSuccess();
    }

    private Result registerCmd(Chain chain, String moduleCode, String cmdName, Integer cmdMode, List<String> argNames, Integer returnType) {
        CmdRegisterReturnType cmdRegisterReturnType = CmdRegisterReturnType.getType(returnType);
        if (cmdMode.intValue() == CmdRegisterMode.NEW_TX.mode() && !CmdRegisterReturnType.STRING_ARRAY.equals((Object)cmdRegisterReturnType)) {
            Log.error("The type of NEW_TX does not support non-string array return values, this return type is [{}]", new Object[]{cmdRegisterReturnType});
            return Result.getFailed((ErrorCode)ContractErrorCode.CMD_REGISTER_NEW_TX_RETURN_TYPE_ERROR);
        }
        Map<String, CmdRegister> cmdRegisterMap = chain.getCmdRegisterMap();
        CmdRegister cmdRegister = cmdRegisterMap.get(cmdName);
        if (cmdRegister != null && !cmdRegister.getModuleCode().equals(moduleCode)) {
            Log.error("Different modules registered duplicate cmd, cmdName is {}, registerd module is {}, registering module is {}", cmdName, cmdRegister.getModuleCode(), moduleCode);
            return Result.getFailed((ErrorCode)ContractErrorCode.DUPLICATE_REGISTER_CMD);
        }
        cmdRegister = new CmdRegister(moduleCode, cmdName, CmdRegisterMode.getMode(cmdMode), argNames, cmdRegisterReturnType);
        if (Log.isDebugEnabled()) {
            Log.debug("registered cmd info: {}", cmdRegister);
        }
        cmdRegisterMap.put(cmdName, cmdRegister);
        return ContractUtil.getSuccess();
    }

    public CmdRegister getCmdRegisterByCmdName(int chainId, String cmdName) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            Log.error("chain not found, chainId is {}", chainId);
            return null;
        }
        Map<String, CmdRegister> cmdRegisterMap = chain.getCmdRegisterMap();
        CmdRegister cmdRegister = cmdRegisterMap.get(cmdName);
        return cmdRegister;
    }

    public Response requestAndResponse(String moduleCode, String cmdName, Map args) throws Exception {
        return this.requestAndResponseInterface.requestAndResponse(moduleCode, cmdName, args);
    }
}

