/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.bo;

import io.nuls.common.ConfigBean;
import io.nuls.contract.enums.BlockType;
import io.nuls.contract.manager.ContractTxCreateUnconfirmedManager;
import io.nuls.contract.model.bo.BatchInfo;
import io.nuls.contract.model.bo.BatchInfoV8;
import io.nuls.contract.model.bo.CmdRegister;
import io.nuls.contract.model.bo.ContractTokenAssetsInfo;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ethereum.config.CommonConfig;
import org.ethereum.config.DefaultConfig;

public class Chain {
    private static ThreadLocal<Integer> currentThreadBlockType = new ThreadLocal();
    private ConfigBean config;
    private ProgramExecutor programExecutor;
    private CommonConfig commonConfig;
    private DefaultConfig defaultConfig;
    private ContractTxCreateUnconfirmedManager contractTxCreateUnconfirmedManager;
    private BatchInfo batchInfo;
    private BatchInfo verifyBatchInfo;
    private BatchInfoV8 batchInfoV8;
    private BatchInfoV8 verifyBatchInfoV8;
    private Map<String, CmdRegister> cmdRegisterMap = new ConcurrentHashMap<String, CmdRegister>();
    private Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = new HashMap<String, ContractTokenAssetsInfo>();
    private Map<String, String> tokenAssetsContractAddressInfoMap = new HashMap<String, String>();

    public static void putCurrentThreadBlockType(Integer blockType) {
        currentThreadBlockType.set(blockType);
    }

    public static Integer currentThreadBlockType() {
        return currentThreadBlockType.get();
    }

    public int getChainId() {
        return this.config.getChainId();
    }

    public ConfigBean getConfig() {
        return this.config;
    }

    public void setConfig(ConfigBean config) {
        this.config = config;
    }

    public ProgramExecutor getProgramExecutor() {
        return this.programExecutor;
    }

    public void setProgramExecutor(ProgramExecutor programExecutor) {
        this.programExecutor = programExecutor;
    }

    public CommonConfig getCommonConfig() {
        return this.commonConfig;
    }

    public void setCommonConfig(CommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DefaultConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public ContractTxCreateUnconfirmedManager getContractTxCreateUnconfirmedManager() {
        return this.contractTxCreateUnconfirmedManager;
    }

    public void setContractTxCreateUnconfirmedManager(ContractTxCreateUnconfirmedManager contractTxCreateUnconfirmedManager) {
        this.contractTxCreateUnconfirmedManager = contractTxCreateUnconfirmedManager;
    }

    public BatchInfo getBatchInfo() {
        Integer blockType = currentThreadBlockType.get();
        if (blockType == null) {
            return null;
        }
        if (blockType.intValue() == BlockType.PACKAGE_BLOCK.type()) {
            return this.batchInfo;
        }
        if (blockType.intValue() == BlockType.VERIFY_BLOCK.type()) {
            return this.verifyBatchInfo;
        }
        Log.error("Unkown blockType! - [{}]", blockType);
        return null;
    }

    public void setBatchInfo(BatchInfo batchInfo) {
        Integer blockType = currentThreadBlockType.get();
        if (blockType == null) {
            return;
        }
        if (blockType.intValue() == BlockType.PACKAGE_BLOCK.type()) {
            this.batchInfo = batchInfo;
            return;
        }
        if (blockType.intValue() == BlockType.VERIFY_BLOCK.type()) {
            this.verifyBatchInfo = batchInfo;
            return;
        }
        Log.error("Setting value error. Unkown blockType! - [{}]", blockType);
    }

    public void clearOldBatchInfo() {
        Log.info("clear Old BatchInfo.");
        this.batchInfo = null;
        this.verifyBatchInfo = null;
    }

    public void clearBatchInfo() {
        Log.info("clear BatchInfo.");
        this.batchInfoV8 = null;
        this.verifyBatchInfoV8 = null;
    }

    public BatchInfoV8 getBatchInfoV8() {
        Integer blockType = currentThreadBlockType.get();
        if (blockType == null) {
            return null;
        }
        if (blockType.intValue() == BlockType.PACKAGE_BLOCK.type()) {
            return this.batchInfoV8;
        }
        if (blockType.intValue() == BlockType.VERIFY_BLOCK.type()) {
            return this.verifyBatchInfoV8;
        }
        Log.error("Unkown blockType! - [{}]", blockType);
        return null;
    }

    public void setBatchInfoV8(BatchInfoV8 batchInfo) {
        Integer blockType = currentThreadBlockType.get();
        if (blockType == null) {
            return;
        }
        if (blockType.intValue() == BlockType.PACKAGE_BLOCK.type()) {
            this.batchInfoV8 = batchInfo;
            return;
        }
        if (blockType.intValue() == BlockType.VERIFY_BLOCK.type()) {
            this.verifyBatchInfoV8 = batchInfo;
            return;
        }
        Log.error("Setting value error. Unkown blockType! - [{}]", blockType);
    }

    public Map<String, CmdRegister> getCmdRegisterMap() {
        return this.cmdRegisterMap;
    }

    public void setCmdRegisterMap(Map<String, CmdRegister> cmdRegisterMap) {
        this.cmdRegisterMap = cmdRegisterMap;
    }

    public Map<String, ContractTokenAssetsInfo> getTokenAssetsInfoMap() {
        return this.tokenAssetsInfoMap;
    }

    public void setTokenAssetsInfoMap(Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap) {
        this.tokenAssetsInfoMap = tokenAssetsInfoMap;
    }

    public Map<String, String> getTokenAssetsContractAddressInfoMap() {
        return this.tokenAssetsContractAddressInfoMap;
    }

    public void setTokenAssetsContractAddressInfoMap(Map<String, String> tokenAssetsContractAddressInfoMap) {
        this.tokenAssetsContractAddressInfoMap = tokenAssetsContractAddressInfoMap;
    }
}

