/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.enums.ContractStatus;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class ContractAddressDto {
    @ApiModelProperty(description="Contract address")
    private String contractAddress;
    @ApiModelProperty(description="Contract creation time")
    private long createTime;
    @ApiModelProperty(description="Block height during contract creation")
    private long height;
    @ApiModelProperty(description="Contract creation confirmation times")
    private long confirmCount;
    @ApiModelProperty(description="Contract alias")
    private String alias;
    @ApiModelProperty(description="Contract status\uff080 - Does not exist or is being created, 1 - normal, 2 - Removed, 3 - Creation failed, 4 - Locked\uff09")
    private int status;
    @ApiModelProperty(description="Error message for contract creation failure")
    private String msg;

    public ContractAddressDto() {
    }

    public ContractAddressDto(ContractAddressInfoPo po, long bestBlockHeight, int status) throws NulsException {
        this.contractAddress = AddressTool.getStringAddressByBytes((byte[])po.getContractAddress());
        this.createTime = po.getCreateTime();
        this.height = po.getBlockHeight();
        this.alias = po.getAlias();
        this.status = status;
        if (this.height > 0L) {
            this.confirmCount = bestBlockHeight - this.height;
            if (this.confirmCount == 0L) {
                this.status = ContractStatus.NOT_EXISTS_OR_CONFIRMING.status();
            } else if (this.confirmCount < 7L) {
                this.status = ContractStatus.LOCKED.status();
            }
        } else {
            this.confirmCount = 0L;
        }
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getConfirmCount() {
        return this.confirmCount;
    }

    public void setConfirmCount(long confirmCount) {
        this.confirmCount = confirmCount;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

