/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.model.bo.Output;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class ContractOutputDto {
    @ApiModelProperty(description="Transfer address")
    private String to;
    @ApiModelProperty(description="Transfer amount")
    private String value;
    @ApiModelProperty(description="Transfer amount lock time")
    private long lockTime;

    public ContractOutputDto() {
    }

    public ContractOutputDto(Output output) {
        this.to = AddressTool.getStringAddressByBytes((byte[])output.getTo());
        this.value = ContractUtil.bigInteger2String(output.getValue());
        this.lockTime = output.getLockTime();
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(long lockTime) {
        this.lockTime = lockTime;
    }
}

