/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.contract.model.bo.ContractResult;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ContractPackageDto {
    private byte[] stateRoot;
    private List<byte[]> offlineTxHashList;
    private List<String> resultTxList;
    private List<String> resultOrginTxList;
    private Map<String, ContractResult> contractResultMap;

    public ContractPackageDto(List<byte[]> offlineTxHashList, List<String> resultTxList, List<String> resultOrginTxList) {
        this.offlineTxHashList = offlineTxHashList;
        this.resultTxList = resultTxList;
        this.resultOrginTxList = resultOrginTxList;
    }

    public void makeContractResultMap(List<ContractResult> contractResultList) {
        this.contractResultMap = contractResultList.stream().collect(Collectors.toMap(c -> c.getHash(), Function.identity(), (key1, key2) -> key2, LinkedHashMap::new));
    }

    public void setStateRoot(byte[] stateRoot) {
        this.stateRoot = stateRoot;
    }

    public byte[] getStateRoot() {
        return this.stateRoot;
    }

    public List<String> getResultTxList() {
        return this.resultTxList;
    }

    public void setResultTxList(List<String> resultTxList) {
        this.resultTxList = resultTxList;
    }

    public List<String> getResultOrginTxList() {
        return this.resultOrginTxList;
    }

    public void setResultOrginTxList(List<String> resultOrginTxList) {
        this.resultOrginTxList = resultOrginTxList;
    }

    public List<byte[]> getOfflineTxHashList() {
        return this.offlineTxHashList;
    }

    public void setOfflineTxHashList(List<byte[]> offlineTxHashList) {
        this.offlineTxHashList = offlineTxHashList;
    }

    public Map<String, ContractResult> getContractResultMap() {
        return this.contractResultMap;
    }
}

