/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.model.dto.ContractTokenTransferInfo;
import io.nuls.contract.model.po.ContractTokenTransferInfoPo;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class ContractTokenTransferDto {
    @ApiModelProperty(description="Contract address")
    private String contractAddress;
    @ApiModelProperty(description="Payer")
    private String from;
    @ApiModelProperty(description="Payee")
    private String to;
    @ApiModelProperty(description="Transfer amount")
    private String value;
    @ApiModelProperty(description="tokenname")
    private String name;
    @ApiModelProperty(description="tokensymbol")
    private String symbol;
    @ApiModelProperty(description="tokenSupported Decimal Places")
    private long decimals;

    public ContractTokenTransferDto(ContractTokenTransferInfoPo po) {
        this.contractAddress = po.getContractAddress();
        if (po.getFrom() != null) {
            this.from = AddressTool.getStringAddressByBytes((byte[])po.getFrom());
        }
        if (po.getTo() != null) {
            this.to = AddressTool.getStringAddressByBytes((byte[])po.getTo());
        }
        this.value = ContractUtil.bigInteger2String(po.getValue());
        this.name = po.getName();
        this.symbol = po.getSymbol();
        this.decimals = po.getDecimals();
    }

    public ContractTokenTransferDto(ContractTokenTransferInfo info) {
        this.contractAddress = info.getContractAddress();
        this.from = info.getFrom();
        this.to = info.getTo();
        this.value = info.getValue();
        this.name = info.getName();
        this.symbol = info.getSymbol();
        this.decimals = info.getDecimals();
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public long getDecimals() {
        return this.decimals;
    }

    public void setDecimals(long decimals) {
        this.decimals = decimals;
    }
}

