/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.contract.model.dto.CallContractDataDto;
import io.nuls.contract.model.dto.ContractResultDto;
import io.nuls.contract.model.dto.ContractTransferDataDto;
import io.nuls.contract.model.dto.CreateContractDataDto;
import io.nuls.contract.model.dto.DeleteContractDataDto;
import io.nuls.contract.model.dto.InputDto;
import io.nuls.contract.model.dto.OutputDto;
import io.nuls.contract.model.tx.ContractBaseTransaction;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.model.txdata.ContractTransferData;
import io.nuls.contract.rpc.call.BlockCall;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.TypeDescriptor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApiModel
public class ContractTransactionDto {
    @ApiModelProperty(description="transactionhash")
    private String hash;
    @ApiModelProperty(description="Transaction type")
    private Integer type;
    @ApiModelProperty(description="Transaction time")
    private Long time;
    @ApiModelProperty(description="block height")
    private Long blockHeight;
    @ApiModelProperty(description="Transaction fees")
    private String fee;
    @ApiModelProperty(description="Transaction amount")
    private String value;
    @ApiModelProperty(description="Remarks")
    private String remark;
    @ApiModelProperty(description="Signature information")
    private String scriptSig;
    @ApiModelProperty(description="Transaction status\uff080 - Confirming,1 - Confirmed\uff09")
    private Integer status;
    @ApiModelProperty(description="Number of transaction confirmations")
    private Long confirmCount;
    @ApiModelProperty(description="Transaction size")
    private int size;
    @ApiModelProperty(description="Transaction Input Set", type=@TypeDescriptor(value=List.class, collectionElement=InputDto.class))
    private List<InputDto> inputs;
    @ApiModelProperty(description="Transaction output set", type=@TypeDescriptor(value=List.class, collectionElement=OutputDto.class))
    private List<OutputDto> outputs;
    @ApiModelProperty(description="Contract trading business data", type=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="data", description="Reflect different business data based on contract transaction types\uff08Here, in order to describe four situations, the four businesses are described together, but in reality, they do not exist simultaneously, only one exists\uff09", valueType=ContractTransactionTxDataDescriptor.class)}))
    private Map<String, Object> txData;
    @ApiModelProperty(description="Contract execution results")
    private ContractResultDto contractResult;

    public ContractTransactionDto(int chainId, ContractBaseTransaction tx) throws NulsException {
        this.hash = tx.getHash().toHex();
        this.type = tx.getType();
        this.time = tx.getTime();
        this.blockHeight = tx.getBlockHeight();
        this.fee = ContractUtil.bigInteger2String(tx.getCoinDataObj().getFeeByAsset(chainId, 1));
        this.size = tx.getSize();
        this.txData = this.makeTxData(tx);
        long bestBlockHeight = BlockCall.getLatestHeight(chainId);
        this.confirmCount = this.blockHeight > 0L || TxStatusEnum.CONFIRMED.equals((Object)tx.getStatus()) ? Long.valueOf(bestBlockHeight - this.blockHeight) : Long.valueOf(0L);
        this.status = TxStatusEnum.CONFIRMED.equals((Object)tx.getStatus()) ? Integer.valueOf(1) : Integer.valueOf(0);
        if (tx.getRemark() != null) {
            this.setRemark(new String(tx.getRemark(), StandardCharsets.UTF_8));
        }
        if (tx.getTransactionSignature() != null) {
            this.setScriptSig(RPCUtil.encode((byte[])tx.getTransactionSignature()));
        }
        CoinData coinData = tx.getCoinDataObj();
        this.inputs = new ArrayList<InputDto>();
        this.outputs = new ArrayList<OutputDto>();
        if (coinData != null) {
            List froms = coinData.getFrom();
            for (CoinFrom from : froms) {
                this.inputs.add(new InputDto(from));
            }
            List tos = coinData.getTo();
            for (CoinTo to : tos) {
                this.outputs.add(new OutputDto(to));
            }
        }
    }

    private Map<String, Object> makeTxData(ContractBaseTransaction tx) throws NulsException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ContractData txData = (ContractData)tx.getTxDataObj();
        if (this.type == 15) {
            result.put("data", new CreateContractDataDto(txData));
        } else if (this.type == 16) {
            result.put("data", new CallContractDataDto(txData));
        } else if (this.type == 17) {
            result.put("data", new DeleteContractDataDto(txData));
        } else if (this.type == 18) {
            result.put("data", new ContractTransferDataDto((ContractTransferData)txData));
        }
        return result;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public Long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(Long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public String getFee() {
        return this.fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getScriptSig() {
        return this.scriptSig;
    }

    public void setScriptSig(String scriptSig) {
        this.scriptSig = scriptSig;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getConfirmCount() {
        return this.confirmCount;
    }

    public void setConfirmCount(Long confirmCount) {
        this.confirmCount = confirmCount;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<InputDto> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputDto> inputs) {
        this.inputs = inputs;
    }

    public List<OutputDto> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<OutputDto> outputs) {
        this.outputs = outputs;
    }

    public Map<String, Object> getTxData() {
        return this.txData;
    }

    public void setTxData(Map<String, Object> txData) {
        this.txData = txData;
    }

    public ContractResultDto getContractResult() {
        return this.contractResult;
    }

    public void setContractResult(ContractResultDto contractResult) {
        this.contractResult = contractResult;
    }

    @ApiModel
    private static class ContractTransactionTxDataDescriptor {
        @ApiModelProperty(description="Publish business data for contract transactions")
        private CreateContractDataDto create;
        @ApiModelProperty(description="Call business data for contract transactions")
        private CallContractDataDto call;
        @ApiModelProperty(description="Delete business data for contract transactions")
        private DeleteContractDataDto delete;
        @ApiModelProperty(description="Business data for contract transfer transactions")
        private ContractTransferDataDto transfer;

        private ContractTransactionTxDataDescriptor() {
        }

        public CreateContractDataDto getCreate() {
            return this.create;
        }

        public void setCreate(CreateContractDataDto create) {
            this.create = create;
        }

        public CallContractDataDto getCall() {
            return this.call;
        }

        public void setCall(CallContractDataDto call) {
            this.call = call;
        }

        public DeleteContractDataDto getDelete() {
            return this.delete;
        }

        public void setDelete(DeleteContractDataDto delete) {
            this.delete = delete;
        }

        public ContractTransferDataDto getTransfer() {
            return this.transfer;
        }

        public void setTransfer(ContractTransferDataDto transfer) {
            this.transfer = transfer;
        }
    }
}

