/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.NulsHash;
import io.nuls.contract.model.txdata.ContractTransferData;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class ContractTransferDataDto {
    @ApiModelProperty(description="Call contract transactionshash\uff08Source transactionhashContract trading is derived from calling contract trading\uff09")
    private String orginTxHash;
    @ApiModelProperty(description="Contract address")
    private String contractAddress;

    public ContractTransferDataDto(ContractTransferData transferData) {
        NulsHash thatOrginTxHash = transferData.getOrginTxHash();
        this.orginTxHash = thatOrginTxHash == null ? null : thatOrginTxHash.toHex();
        this.contractAddress = AddressTool.getStringAddressByBytes((byte[])transferData.getContractAddress());
    }

    public String getOrginTxHash() {
        return this.orginTxHash;
    }

    public void setOrginTxHash(String orginTxHash) {
        this.orginTxHash = orginTxHash;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }
}

