/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ContractOfflineTxHashPo
extends BaseNulsData {
    private int size;
    private List<byte[]> hashList;

    public ContractOfflineTxHashPo() {
    }

    public ContractOfflineTxHashPo(List<byte[]> hashList) {
        this.size = hashList != null ? hashList.size() : 0;
        this.hashList = hashList == null ? new ArrayList() : hashList;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.size);
        for (byte[] hash : this.hashList) {
            stream.write(hash);
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.size = byteBuffer.readUint16();
        this.hashList = new ArrayList<byte[]>();
        for (int i = 0; i < this.size; ++i) {
            this.hashList.add(byteBuffer.readBytes(32));
        }
    }

    public int size() {
        return 2 + 32 * this.size;
    }

    public List<byte[]> getHashList() {
        return this.hashList;
    }

    public void setHashList(List<byte[]> hashList) {
        this.hashList = hashList;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

