/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class TransactionInfoPo
extends BaseNulsData {
    public static byte CONFIRMED = 1;
    public static byte UNCONFIRMED = 0;
    private NulsHash txHash;
    private long blockHeight;
    private long time;
    private byte[] addresses;
    private int txType;
    private byte status;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.txHash.getBytes());
        stream.writeUint32(this.blockHeight);
        stream.writeUint32(this.time);
        stream.writeBytesWithLength(this.addresses);
        stream.writeUint16(this.txType);
        stream.write((int)this.status);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.txHash = byteBuffer.readHash();
        this.blockHeight = byteBuffer.readUint32();
        this.time = byteBuffer.readUint32();
        this.addresses = byteBuffer.readByLengthByte();
        this.txType = byteBuffer.readUint16();
        this.status = byteBuffer.readByte();
    }

    public int size() {
        int size = 0;
        size += 32;
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBytes((byte[])this.addresses);
        size += SerializeUtils.sizeOfUint16();
        return ++size;
    }

    public NulsHash getTxHash() {
        return this.txHash;
    }

    public void setTxHash(NulsHash txHash) {
        this.txHash = txHash;
    }

    public byte[] getAddresses() {
        return this.addresses;
    }

    public void setAddresses(byte[] addresses) {
        this.addresses = addresses;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getTxType() {
        return this.txType;
    }

    public void setTxType(int txType) {
        this.txType = txType;
    }

    public int compareTo(long thatTime) {
        if (this.time > thatTime) {
            return -1;
        }
        if (this.time < thatTime) {
            return 1;
        }
        return 0;
    }
}

