/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.processor;

import io.nuls.base.data.BlockHeader;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.service.ContractService;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;

@Component
public class DeleteContractTxProcessor {
    @Autowired
    private ContractService contractService;
    @Autowired
    private ContractHelper contractHelper;

    public Result onCommit(int chainId, ContractWrapperTransaction tx) {
        BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeader(chainId);
        long blockHeight = blockHeader.getHeight();
        ContractResult contractResult = tx.getContractResult();
        contractResult.setBlockHeight(blockHeight);
        return this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
    }

    public Result onRollback(int chainId, ContractWrapperTransaction tx) {
        Log.info("rollback delete tx, hash is {}", tx.getHash().toString());
        return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
    }

    public Result onCommitV8(int chainId, ContractWrapperTransaction tx) {
        BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeaderV8(chainId);
        long blockHeight = blockHeader.getHeight();
        ContractResult contractResult = tx.getContractResult();
        contractResult.setBlockHeight(blockHeight);
        return this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
    }

    public Result onRollbackV8(int chainId, ContractWrapperTransaction tx) {
        Log.info("rollback delete tx, hash is {}", tx.getHash().toString());
        return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
    }
}

